<?php
/**
 * KSeF Certificate Service class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Certificate;

use App\Mailer;

/**
 * KSeF Certificate Service class.
 */
final class CertificateService
{
	/**
	 * Send expiration notification emails for certificates.
	 * 
	 * @param array $certificates Array of certificate data (already filtered by expiration dates)
	 *	
	 * @return void
	 */
	public static function sendExpirationNotification(array $certificates): void
	{
		foreach ($certificates as $data) {
			$expirationDate = new \DateTime($data['date_valid_to']);
			$now = new \DateTime();
			$daysUntilExpiration = (int) $now->diff($expirationDate)->format('%a');

			Mailer::sendFromTemplate([
				'template' => 'KSeFCertificateExpiration',
				'moduleName' => 'Users',
				'to' => $data['contact_email'],
				'recordId' => $data['id'],
				'name' => $data['name'],
				'days_until_expiration' => $daysUntilExpiration,
			]);
		}
	}
}
