<?php
/**
 * Certificate expiration check and notify.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Cron;

use App\CronHandler;
use App\Integrations\KSeF\Repository\CertificateRepository;
use App\Integrations\KSeF\Service\Certificate\CertificateService;

class CertificateExpiration extends CronHandler
{
	/** @var int Number of days before expiration to trigger first notification */
	public const DAYS_BEFORE_EXPIRATION_FIRST = 7;

	/** @var int Number of days before expiration to trigger second notification */
	public const DAYS_BEFORE_EXPIRATION_SECOND = 1;

	/** {@inheritdoc} */
	public function process()
	{
		$certificateRepository = new CertificateRepository();
		$certificateService = new CertificateService();

		$now = new \DateTime();
		$firstNotificationDate = (clone $now)->modify('+' . self::DAYS_BEFORE_EXPIRATION_FIRST . ' days');
		$secondNotificationDate = (clone $now)->modify('+' . self::DAYS_BEFORE_EXPIRATION_SECOND . ' days');

		$certificates = $certificateRepository->findByExpirationDates([$firstNotificationDate, $secondNotificationDate]);

		if (!empty($certificates)) {
			$certificateService::sendExpirationNotification($certificates);
		}
	}


}
