<?php
/**
 * KSeF Related Record Value Resolver class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Mapper\Resolver;

use App\Integrations\KSeF\Model\Mapper\Pair;
use App\Record;

class RelatedRecordValueResolver implements ValueResolverInterface
{
	public function supports(Pair $pair, array|\Vtiger_Record_Model|null $data): bool
	{
		return str_contains($pair->getField(), ':');
	}

	public function resolve(
		Pair $pair,
		array|\Vtiger_Record_Model|null $data,
		ValueResolverRegistry $registry
	): mixed {
		[$relatedFieldName, $relatedModule, $sourceField] = array_pad(
			explode(':', $pair->getField()),
			3,
			null
		);

		$relatedRecordId = $registry->getMapper()->getRecord()->get($sourceField);
		if (!$relatedRecordId || !Record::isExists($relatedRecordId, $relatedModule)) {
			return null;
		}
		$relatedRecord = \Vtiger_Record_Model::getInstanceById($relatedRecordId, $relatedModule);

		return $relatedRecord->get($relatedFieldName);
	}
}
