<?php
/**
 * KSeF Value Resolver Registry class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Mapper\Resolver;

use App\Integrations\KSeF\Exception\KSeFMapperException;
use App\Integrations\KSeF\Model\Mapper\AbstractMapper;
use App\Integrations\KSeF\Model\Mapper\Pair;

class ValueResolverRegistry
{
	private array $resolvers = [];
	private ?AbstractMapper $mapper = null;

	public function register(ValueResolverInterface $resolver): self
	{
		$this->resolvers[] = $resolver;

		return $this;
	}

	public function setMapper(AbstractMapper $mapper): self
	{
		$this->mapper = $mapper;

		return $this;
	}

	public function getMapper(): AbstractMapper
	{
		return $this->mapper;
	}

	public function resolve(Pair $pair, array|\Vtiger_Record_Model|null $data): mixed
	{
		if (!$this->mapper) {
			throw new KSeFMapperException('Context not set on registry');
		}

		foreach ($this->resolvers as $resolver) {
			if ($resolver->supports($pair, $data)) {
				return $resolver->resolve($pair, $data, $this);
			}
		}

		throw new KSeFMapperException("No resolver found for field: {$pair->getField()}");
	}
}
