<?php
/**
 * KSeF Reader Buyer Fields Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Reader Buyer Fields Rule class.
 *
 * Handles building buyer-specific fields from Podmiot2.
 */
final class BuyerFieldsRule implements RuleInterface
{
	private AbstractRecordBuilder $builder;

	/** {@inheritDoc} */
	public function __construct(AbstractRecordBuilder $builder)
	{
		$this->builder = $builder;
	}

	/** {@inheritDoc} */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void {
		$buyerNip = $this->builder->getOptionalString('//Podmiot2/DaneIdentyfikacyjne/NIP');
		if ($buyerNip) {
			$this->builder->setFieldIfMapped($record, '//Podmiot2/DaneIdentyfikacyjne/NIP', $buyerNip);
		}

		$buyerName = $this->builder->getOptionalString('//Podmiot2/DaneIdentyfikacyjne/Nazwa');
		if ($buyerName) {
			$this->builder->setFieldIfMapped($record, '//Podmiot2/DaneIdentyfikacyjne/Nazwa', $buyerName);
		}
	}
}
