<?php
/**
 * KSeF Reader Footer Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Reader Footer Rule class.
 *
 * Handles building footer fields from Stopka (full company name, REGON, KRS, footer text).
 */
final class FooterRule implements RuleInterface
{
	private AbstractRecordBuilder $builder;

	/** {@inheritDoc} */
	public function __construct(AbstractRecordBuilder $builder)
	{
		$this->builder = $builder;
	}

	/** {@inheritDoc} */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void {
		$fullName = $this->builder->getOptionalString('//Stopka/Rejestry/PelnaNazwa');
		if ($fullName) {
			$this->builder->setFieldIfMapped($record, '//Stopka/Rejestry/PelnaNazwa', $fullName);
		}

		$regon = $this->builder->getOptionalString('//Stopka/Rejestry/REGON');
		if ($regon) {
			$this->builder->setFieldIfMapped($record, '//Stopka/Rejestry/REGON', $regon);
		}

		$krs = $this->builder->getOptionalString('//Stopka/Rejestry/KRS');
		if ($krs) {
			$this->builder->setFieldIfMapped($record, '//Stopka/Rejestry/KRS', $krs);
		}

		$stopkaText = $this->builder->getOptionalString('//Stopka/Informacje/StopkaFaktury');
		if ($stopkaText) {
			$this->builder->setFieldIfMapped($record, '//Stopka/Informacje/StopkaFaktury', $stopkaText);
		}
	}
}
