<?php
/**
 * KSeF Reader Rule interface file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Mapper\MapperService;
use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Reader Rule interface.
 */
interface RuleInterface
{
	/**
	 * Constructor.
	 *
	 * @param AbstractRecordBuilder $builder The record builder instance
	 */
	public function __construct(AbstractRecordBuilder $builder);

	/**
	 * Apply the rule to populate invoice record from XML.
	 *
	 * @param \Vtiger_Record_Model $record        The record model to populate
	 * @param MapperService        $mapperService The mapper service for field mapping
	 * @param array                $context       Additional context data (currency, fileName, etc.)
	 *
	 * @return void
	 */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void;
}
