<?php
/**
 * KSeF Reader Seller Fields Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Reader Seller Fields Rule class.
 *
 * Handles building seller-specific fields from Podmiot1.
 */
final class SellerFieldsRule implements RuleInterface
{
	private AbstractRecordBuilder $builder;

	/** {@inheritDoc} */
	public function __construct(AbstractRecordBuilder $builder)
	{
		$this->builder = $builder;
	}

	/** {@inheritDoc} */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void {
		$sellerNip = $this->builder->getOptionalString('//Podmiot1/DaneIdentyfikacyjne/NIP');
		if ($sellerNip) {
			$this->builder->setFieldIfMapped($record, '//Podmiot1/DaneIdentyfikacyjne/NIP', $sellerNip);
		}

		$sellerName = $this->builder->getOptionalString('//Podmiot1/DaneIdentyfikacyjne/Nazwa');
		if ($sellerName) {
			$this->builder->setFieldIfMapped($record, '//Podmiot1/DaneIdentyfikacyjne/Nazwa', $sellerName);
		}

		$sellerAddrL1 = $this->builder->getOptionalString('//Podmiot1/Adres/AdresL1');
		$sellerAddrL2 = $this->builder->getOptionalString('//Podmiot1/Adres/AdresL2');

		$sellerAddr = trim($sellerAddrL1 . ' ' . $sellerAddrL2);
		if ($sellerAddr) {
			$this->builder->setFieldIfMapped($record, '//Podmiot1/Adres/AdresL1', $sellerAddr);
		}
	}
}
