<?php
/**
 * KSeF Reader Summary Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Reader Summary Rule class.
 */
final class SummaryRule implements RuleInterface
{
	private AbstractRecordBuilder $builder;

	/** {@inheritDoc} */
	public function __construct(AbstractRecordBuilder $builder)
	{
		$this->builder = $builder;
	}

	/** {@inheritDoc} */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void {
		$p15 = $this->builder->getOptionalDecimal('//Fa/P_15');
		if (null !== $p15) {
			$this->builder->setFieldIfMapped($record, '//Fa/P_15', (string) $p15);
			$record->set('sum_gross', $p15);
		}

		$nettoSum = 0.0;
		$lineNodes = $this->builder->getXml()->xpath('//Fa/FaWiersz');
		if (!empty($lineNodes)) {
			foreach ($lineNodes as $lineNode) {
				$p11 = $this->builder->getOptionalDecimal('P_11', $lineNode);
				if (null !== $p11) {
					$nettoSum += $p11;
				}
			}
		}

		$record->set('sum_total', $nettoSum);
	}
}
