<?php
/**
 * SMTP repository file.
 *
 * @package \App\Mail
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Mail\Account\Repository;

use App\Db;
use App\Mail\Account\Entity\SmtpEntity;

/**
 * SMTP repository class.
 */
class SmtpRepository implements AccountRepositoryInterface
{
	protected const TABLE_NAME = 's_#__mail_smtp';

	private readonly Db $db;

	public function __construct()
	{
		$this->db = Db::getInstance('admin');
	}

	public function findById(int $userId): ?SmtpEntity
	{
		$data = (new \App\Db\Query())->from(self::TABLE_NAME)->where(['id' => $userId])->one() ?: [];

		return $data ? (new SmtpEntity())->setData($data) : null;
	}

	public function update(SmtpEntity $entry): string|int
	{
		$result = 0;
		if (!$data = $entry->getValuesForSave()) {
			return $result;
		}

		$transaction = $this->db->beginTransaction();
		try {
			$result = $this->db->createCommand()->update(self::TABLE_NAME, $data, ['id' => $entry->getId()])->execute();
			$transaction->commit();
		} catch (\Throwable $ex) {
			$transaction->rollBack();
			throw $ex;
		}

		return $result;
	}
}
