<?php
/**
 * Class to get coordinates.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 */

namespace App\Map\Coordinates;

use App\Map\BaseDriver;

/**
 * Base Connector to get coordinates.
 */
abstract class Base extends BaseDriver
{
	/**
	 * Documentation URL.
	 *
	 * @var string
	 */
	protected string $docUrl;

	/**
	 * Function to get coordinates from base information about address.
	 *
	 * @param array $addressInfo
	 * @param bool  $onlyOne
	 *
	 * @return array|null
	 */
	abstract public function getCoordinates(array $addressInfo, bool $onlyOne = true): ?array;

	/**
	 * Function to get coordinates from string.
	 *
	 * @param string $value
	 *
	 * @return bool|string[]
	 */
	abstract public function getCoordinatesByValue(string $value): array|bool;

	/**
	 * Get documentation URL.
	 *
	 * @return string
	 */
	public function getDocUrl(): string
	{
		return $this->docUrl;
	}
}
