<?php
/**
 * Data mapper for formula expression
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Mapper;

use App\Report\Enums\FieldType;
use App\Report\Factory\FieldFactory;
use App\Report\Model\Expression;
use App\Report\Model\Query;

/** FormulaDataMapper class */
final class FormulaDataMapper
{
	public function __construct(
		private readonly FieldFactory $fieldFactory,
	) {
	}

	/** Map data with expression to array */
	public function map(Expression $expression, array $data): array
	{
		return array_map(
			$this->getMapCallback($expression->getQuery(), $data),
			$expression->getFormulaField(),
		);
	}

	/** Get function called by expression */
	private function getMapCallback(Query $query, array $data): callable
	{
		return function (string $field) use ($query, $data): float {
			$value = (float) $data[$alias = $query->getExpressionByField($field)->getAlias()];

			$field = $this->fieldFactory->create($query, $alias);

			//todo If another case will come, move this logic to separate services
			if (null !== $field && FieldType::percentage === $field->getType()) {
				$value /= 100;
			}

			return $value;
		};
	}
}
