<?php

/**
 * Report data filter model.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model;

use App\Report\Enums\Operator;

/** Filter class */
final class Filter
{
	public function __construct(
		private int $id,
		private FilterGroup $filterGroup,
		private string $firstValue,
		private Operator $operator,
		private null|float|int|string $secondValue = null,
	) {}

	/** Get module name */
	public function getModuleName(): string
	{
		return $this->filterGroup->getQuery()->getModuleName();
	}

	/** Get filter id */
	public function getId(): int
	{
		return $this->id;
	}

	/** Get related filter group */
	public function getFilterGroup(): FilterGroup
	{
		return $this->filterGroup;
	}

	/** Get filtered filed name */
	public function getFirstValue(): string
	{
		return $this->firstValue;
	}

	/** Get filter operator */
	public function getOperator(): Operator
	{
		return $this->operator;
	}

	/** Get filtered value */
	public function getSecondValue(): null|float|int|string
	{
		if (null === $this->secondValue) {
			return $this->secondValue;
		}
		if (\is_string($this->secondValue)) {
			$decoded = json_decode($this->secondValue);
			return JSON_ERROR_NONE === json_last_error() && true === \is_array($decoded)
			? implode('##', $decoded)
			: $this->secondValue;
		}

		return $this->secondValue;
	}
}
