{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<!-- tpl-ReportTemplate-EditViewBlocks -->
	<form class="form-horizontal recordEditView c-modernForm" id="EditView" name="EditView" method="post" action="index.php"
		enctype="multipart/form-data">
		<input type="hidden" name="module" value="{$MODULE}" />
		{if !empty($RECORD_ID)}
			<input type="hidden" name="record" id="recordId" value="{$RECORD_ID}" />
			<input type="hidden" name="fromView" value="Edit" />
			{if $RECORD_ID && !empty($RECORD_ACTIVITY_NOTIFIER)}
				<input type="hidden" id="recordActivityNotifier" data-interval="{App\Config::performance('recordActivityNotifierInterval', 10)}" data-record="{$RECORD_ID}" data-module="{$MODULE}" />
			{/if}
		{else}
			<input type="hidden" name="fromView" value="Create" />
		{/if}
		{if $MODE === 'duplicate'}
			<input type="hidden" name="_isDuplicateRecord" value="true" />
			<input type="hidden" name="_duplicateRecord" value="{\App\Request::_get('record')}" />
		{/if}
		<input type="hidden" name="action" value="Save" />
		{if !empty($RECORD_ID) || $MODE === 'duplicate'}
			{assign var="REPORT_QUERY" value=$RECORD->get('query') }
			<input type="hidden" name="data-sources" value="{\App\Purifier::encodeHtml($REPORT_QUERY['data_sources'])}">
			<input type="hidden" name="query" value="{\App\Purifier::encodeHtml(\App\Json::encode($REPORT_QUERY))}">
		{else}
			<input type="hidden" name="data-sources" value="">
			<input type="hidden" name="query" value="">
		{/if}
		<input type="hidden" name="field-formula" value="">
		<input type="hidden" name="conditions" class="js-condition-value" value="[]" />
		<div class="row min-vh-100">
			<div class="col-md-4 bg-light border-right border-secondary text-secondary js-report-wizard-container">
				<div class="fieldRow">
					<div class="c-modernFormHeading mt-2">
						<i class="c-modernFormHeading__icon ti ti-wand"></i>
						{\App\Language::translate('LBL_REPORT_WIZARD', $MODULE_NAME)}
					</div>
					<div class="mt-2 border-top border-secondary">
						<div>
							<div class="mt-3 pb-3">
								<div class="c-modernFormHeading">
									<i class="c-modernFormHeading__icon ti ti-columns"></i>
									<strong>{\App\Language::translate('LBL_COLUMNS', $MODULE_NAME)}</strong>
									<div class="c-modernFormHeading__actions">
										<button type="button" class="btn btn-primary btn-sm js-add-field-formula" href="#" title="{\App\Language::translate('LBL_ADD_ROW_LEVEL_FORMULA', $MODULE_NAME)}">
											<span class="u-cursor-pointer fa-solid fa-square-root-variable mr-1"></span>
											{\App\Language::translate('LBL_ADD_ROW_LEVEL_FORMULA', $MODULE_NAME)}
										</button>
										<button type="button" class="btn btn-outline-primary btn-sm js-remove-all-selected-columns" href="#" title="{\App\Language::translate('LBL_REMOVE_ALL_COLUMNS', $MODULE_NAME)}">
											<span class="u-cursor-pointer fa-solid fa-trash mr-1"></span>
											{\App\Language::translate('LBL_REMOVE_ALL_COLUMNS', $MODULE_NAME)}
										</button>
									</div>
								</div>
								<p class="d-none c-modernBlockListElement js-selected-columns"
									data-field-formula-id=""
									data-column-formula-id=""
									data-field-order-by=""
									data-field-expression=""
									data-field-function="">
									<i class="c-modernBlockListElement__icon js-report-column-icon d-none"></i>
									<span class="c-modernBlockListElement__title js-column-title"></span>
									<span class="js-sort-container-element d-none">
										<button type="button" class="btn btn-outline-primary btn--square js-sort-order-button" data-js="click">
											<i class="js-popover-tooltip ti ti-sort-ascending d-none js-sort-icon"
												data-val="{\App\Db::ASC}"
												data-content="{\App\Language::translate('LBL_SORT_ASCENDING', $MODULE_NAME)}"
												title="{\App\Language::translate('LBL_SORT_ASCENDING', $MODULE_NAME)}"></i>
											<i class="js-popover-tooltip ti ti-sort-descending d-none js-sort-icon"
												data-val="{\App\Db::DESC}"
												data-content="{\App\Language::translate('LBL_SORT_DESCENDING', $MODULE_NAME)}"
												title="{\App\Language::translate('LBL_SORT_DESCENDING', $MODULE_NAME)}"></i>
											<i class="js-popover-tooltip ti ti-arrows-sort js-sort-icon d-none"
												data-val=""
												data-content="{\App\Language::translate('LBL_SELECT_SORT_ORDER', $MODULE_NAME)}"
												title="{\App\Language::translate('LBL_SELECT_SORT_ORDER', $MODULE_NAME)}"></i>
										</button>
									</span>
									<span class="js-popover-tooltip js-edit-formula u-cursor-pointer mr-1 d-none"
										data-content="{\App\Language::translate('LBL_EDIT_FORMULA', $MODULE_NAME)}"
										title="{\App\Language::translate('LBL_EDIT_FORMULA', $MODULE_NAME)}">
										<button type="button" class="btn btn--square btn-outline-primary ">
											<span class="ti ti-pencil"></span>
										</button>
									</span>
									<button type="button" class="btn btn--square btn-primary js-remove-selected-column u-cursor-pointer js-popover-tooltip"
										data-content="{\App\Language::translate('LBL_REMOVE_COLUMN', $MODULE_NAME)}"
										title="{\App\Language::translate('LBL_REMOVE_COLUMN', $MODULE_NAME)}">
										<i class="ti ti-trash"></i>
									</button>
								</p>
								<div class="js-report-fields-container mt-3">
									<select class="select2 form-control js-select-report-column" data-placeholder="{\App\Language::translate('LBL_ADD_COLUMN',$MODULE_NAME)}">
										<option value="" disabled selected hidden>{\App\Language::translate('LBL_SELECT', $MODULE_NAME)}</option>
									</select>
								</div>
								<div class="js-report-selected-columns c-modernBlockListElement__wrapper"></div>
							</div>
							<div class="mt-3 pb-3">
								<div class="mt-3 pb-4">
									<div class="c-modernFormHeading">
										<i class="c-modernFormHeading__icon ti ti-columns"></i>
										<strong>{\App\Language::translate('LBL_AGGREGATE_COLUMNS', $MODULE_NAME)}</strong>
									</div>
									<div class="js-aggregate-columns-container mt-3">
										<select class="select2 form-control js-select-aggregate-column" data-placeholder="{\App\Language::translate('LBL_SELECT_AGGREGATE_COLUMNS',$MODULE_NAME)}">
											<option value="" disabled selected hidden>{\App\Language::translate('LBL_SELECT', $MODULE_NAME)}</option>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-8 pr-0 pl-0">
				{assign var="BREADCRUMBS_ACTIVE" value=App\Config::layout('breadcrumbs')}
				{if $BREADCRUMBS_ACTIVE}
					<div class="o-breadcrumb widget_header mb-3">
						<div>
							{include file=\App\Layout::getTemplatePath('BreadCrumbs.tpl', $MODULE_NAME)}
						</div>
					</div>
				{/if}
				<div class="col-md-12 pl-2">
					<div class="js-toggle-panel c-panel c-panel--edit row mx-1 mb-3" data-js="click" data-label="LBL_BASIC_INFORMATION">
						<div class="blockHeader c-panel__header align-items-center">
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-right m-2 d-none" data-js="click" data-mode="hide"></span>
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-down m-2" data-js="click" data-mode="show"></span>
							<h5>
								<span class="fa-solid fa-file mr-2"></span>
								{\App\Language::translate('LBL_BASIC_INFORMATION', $MODULE_NAME)}
							</h5>
						</div>
						<div class="c-panel__body c-panel__body--edit blockContent js-block-content"
							data-js="display">
							<div class="row">
								{foreach key=BLOCK_LABEL item=BLOCK_FIELDS from=$RECORD_STRUCTURE name="EditViewBlockLevelLoop"}
									{if $BLOCK_FIELDS|@count lte 0}{continue}{/if}
									{foreach key=FIELD_NAME item=FIELD_MODEL from=$BLOCK_FIELDS name=blockfields}
										<div class="col-12 col-md-4  mb-2 js-field-container">
											<label class="u-text-small-bold mb-1">
												{\App\Language::translate($FIELD_MODEL->getFieldLabel(), $MODULE_NAME)}
												{if $FIELD_MODEL->isMandatory()}<span class="redColor">*</span>{/if}
												{if $FIELD_MODEL->get('tooltip')}
													<div class="js-popover-tooltip ml-1 d-inline my-auto u-h-fit u-cursor-pointer" data-placement="top" data-content="{\App\Language::translate($FIELD_MODEL->get('tooltip'), $MODULE_NAME)}">
														<span class="fas fa-info-circle"></span>
													</div>
												{/if}:
											</label>
											<div class="fieldValue m-auto">
												{include file=\App\Layout::getTemplatePath($FIELD_MODEL->getUITypeModel()->getTemplateName(), $MODULE_NAME) FIELD_MODEL=$FIELD_MODEL MODULE=$MODULE_NAME MODULE_NAME=$MODULE_NAME RECORD=null}
											</div>
										</div>
									{{/foreach}}
								{/foreach}

							</div>
						</div>
					</div>
					<div class="js-toggle-panel c-panel c-panel--edit row mx-1 mb-3" data-js="click" data-label="LBL_REPORT_CONDITIONS">
						<div class="blockHeader c-panel__header align-items-center">
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-right m-2 d-none" data-js="click" data-mode="hide"></span>
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-down m-2" data-js="click" data-mode="show"></span>
							<h5>
								<span class="fas fa-filter fa-sm mr-2"></span>
								{\App\Language::translate('LBL_REPORT_CONDITIONS', $MODULE_NAME)}
							</h5>
						</div>
						<div class="c-panel__body p-2 c-panel__body--edit blockContent js-block-content"
							data-js="display">
							<div class="row">
								{if $RECORD_ID || $RECORD->get('conditions')}
									{assign var=ADVANCE_CRITERIA value=$RECORD->get('conditions')}
									<input type="hidden" name="advanceCriteria" value="{\App\Purifier::encodeHtml(\App\Json::encode($ADVANCE_CRITERIA))}" />
								{else}
									{assign var=ADVANCE_CRITERIA value=[]}
									<input type="hidden" name="advanceCriteria" value="" />
								{/if}
								<div class="col-md-12 js-condition-builder-view p-2">
									{include file=\App\Layout::getTemplatePath('ConditionBuilder.tpl', $MODULE_NAME) ADVANCE_CRITERIA=$ADVANCE_CRITERIA}
								</div>
							</div>
						</div>
					</div>
					<div class="js-toggle-panel c-panel c-panel--edit row mx-1 mb-3" data-js="click" data-label="LBL_REPORT_PREVIEW">
						<div class="blockHeader c-panel__header align-items-center pb-1 pt-1">
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-right m-2 d-none" data-js="click" data-mode="hide"></span>
							<span class="u-cursor-pointer js-block-toggle fas fa-angle-down m-2" data-js="click" data-mode="show"></span>
							<h5>
								<span class="fas fa-table fa-sm mr-2"></span>
								{\App\Language::translate('LBL_REPORT_PREVIEW', $MODULE_NAME)}
								<button class="btn btn-primary u-fs-xs js-refresh-report ml-1" href="#" title="{\App\Language::translate('LBL_REFRESH', $MODULE_NAME)}">
									<span class="u-cursor-pointer fa-solid fa-arrows-rotate mr-1"></span>
									{\App\Language::translate('LBL_REFRESH', $MODULE_NAME)}
								</button>
							</h5>
						</div>
						<div class="c-panel__body c-panel__body--edit blockContent js-block-content"
							data-js="display">
							<div class="row">
								<div class="col-md-12 p-2 js-report-preview">
									<p class="text-center">{\App\Language::translate('LBL_NONE_DATA', $MODULE_NAME)} </p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /tpl-ReportTemplate-EditViewBlocks -->
{/strip}
