<?php

/**
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Controller\Modal;
use App\User;

class OSSMailView_MailsPreview_View extends Modal
{
	/** {@inheritDoc} */
	public $modalSize = 'modal-full';

	/** {@inheritDoc} */
	public $showHeader = false;

	/** {@inheritDoc} */
	public $showFooter = false;

	/** {@inheritDoc} */
	public function checkPermission(App\Request $request)
	{
		$userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
		$permission = $userPrivilegesModel->hasModulePermission($request->getModule());
		if (!$permission) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}

		$srecord = $request->getInteger('srecord');
		$smodule = $request->getByType('smodule');

		$recordPermission = \App\Privilege::isPermitted($smodule, 'DetailView', $srecord);
		if (!$recordPermission) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritDoc} */
	public function process(App\Request $request)
	{
		$mode = $request->getMode();
		$pageNumber = $request->getInteger('page') ?: 1;
		$moduleName = $request->getModule();
		$srecord = $request->getInteger('srecord');
		$smodule = $request->getByType('smodule');
		$type = $request->get('type');
		$record = $request->getInteger('record');
		$mailFilter = $request->get('mailFilter');
		$limit = $request->getInteger('limit');

		$recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);

		$query = $recordModel->getBaseMailsPreviewQuery($srecord, $smodule, $type, $mailFilter);
		$totalCount = (int) $query?->count();

		$pagingModel = new Vtiger_Paging_Model();
		$pagingModel->set('page', $pageNumber);
		$pagingModel->set('limit', $limit);
		$pagingModel->set('prevPageExists', $pageNumber > 1);
		$pagingModel->set('totalCount', $totalCount);
		$pagingModel->calculatePageRange($totalCount);
		$pagingModel->set('nextPageExists', $totalCount > $pageNumber * $pagingModel->getPageLimit());

		$viewer = $this->getViewer($request);
		$viewer->assign('PAGING_MODEL', $pagingModel);
		$viewer->assign('PAGE_NUMBER', $pagingModel->getCurrentPage());
		$viewer->assign('PAGE_COUNT', $pagingModel->getPageCount());
		$viewer->assign('START_PAGIN_FROM', $pagingModel->getStartPagingFrom());
		$viewer->assign('RECOLDLIST', $recordModel->{$mode}($srecord, $smodule, $pagingModel, $type, $mailFilter));
		$viewer->assign('MODULE_NAME', $moduleName);
		$viewer->assign('VIEW_NAME', 'MailsPreview');
		$viewer->assign('MODULE_MODEL', Vtiger_Module_Model::getInstance($moduleName));
		$viewer->assign('SMODULENAME', $smodule);
		$viewer->assign('RECORD', $record);
		$viewer->assign('SRECORD', $srecord);
		$viewer->assign('TYPE', $type);
		$viewer->assign('POPUP', User::getCurrentUserModel()->getDetail('mail_popup'));
		$viewer->assign('LISTVIEW_COUNT', $totalCount);
		$viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
		$viewer->assign('MODAL_SCRIPTS', $this->getModalScripts($request));
		$viewer->assign('MODAL_ID', $this->modalId);
		$viewer->view('MailsPreview.tpl', 'OSSMailView');
	}
}
