<?php

/**
 * Project ProjectHandler handler class.
 *
 * @package   Handler
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Arkadiusz Adach <a.adach@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
class Project_ProjectHandler_Handler
{
	/* Method per module */
	const PROCESS = [
		'Project' => 'Project_Module_Model::updateProgress',
		'ProjectMilestone' => 'ProjectMilestone_Module_Model::updateProgress',
	];

	/**
	 * EntityAfterSave handler function.
	 *
	 * @param \App\EventHandler $eventHandler
	 */
	public function entityAfterSave(App\EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		if (!$recordModel->isNew()) {
			if (false !== ($value = $recordModel->getPreviousValue('parentid'))) {
				if (!empty($recordModel->get('parentid'))) {
					(new \App\BatchMethod(['method' => static::PROCESS[$recordModel->getModuleName()], 'params' => [$recordModel->get('parentid')]]))->save();
				}
				if (!empty($value)) {
					(new \App\BatchMethod(['method' => static::PROCESS[$recordModel->getModuleName()], 'params' => [$value]]))->save();
				}
			}
		}
	}

	/**
	 * EntityChangeState handler function.
	 *
	 * @param \App\EventHandler $eventHandler
	 */
	public function entityChangeState(App\EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		if (!$recordModel->isEmpty('parentid')) {
			(new \App\BatchMethod(['method' => static::PROCESS[$recordModel->getModuleName()], 'params' => [$recordModel->get('parentid')]]))->save();
		}
	}
}
