<?php
/**
 * Settings KSeF delete action file.
 *
 * @package Settings.Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

use App\Request;

/**
 * Settings KSeF delete action class.
 */
class Settings_KSeF_DeleteAjax_Action extends Settings_Vtiger_Delete_Action
{
	/** {@inheritdoc} */
	public function process(Request $request)
	{
		Settings_KSeF_Record_Model::getInstanceById($request->getInteger('record'))->delete();
		$response = new Vtiger_Response();
		$response->setResult(['success' => true]);
		$response->emit();
	}
}
