<?php

/**
 * List file for KSeF integration model.
 *
 * @package Settings.Model
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

use App\Integrations\KSeF\KSeF;
use App\Language;
use App\YetiForce\Register;

/**
 * List class for KSeF integration model.
 */
class Settings_KSeF_ListView_Model extends Settings_Vtiger_ListView_Model
{
	/** {@inheritdoc} */
	public function getBasicLinks()
	{
		$basicLinks = [];
		$ksef = new KSeF();

		/** @var Settings_KSeF_Module_Model $moduleModel */
		$moduleModel = $this->getModule();

		$isRegistered = Register::isRegistered();
		if ($isRegistered && $moduleModel->hasCreatePermissions()) {
			$basicLinks[] = [
				'linktype' => 'LISTVIEWRECORD',
				'linklabel' => 'LBL_ADD_RECORD',
				'linkdata' => ['url' => $moduleModel->getCreateRecordUrl()],
				'linkclass' => 'btn-primary mr-2 js-add-record-modal',
				'linkicon' => 'fas fa-plus',
				'showLabel' => 1
			];
		}
		if ($isRegistered && !$ksef->isActive()) {
			$basicLinks[] = [
				'linktype' => 'LISTVIEWRECORD',
				'linklabel' => Language::translate('LBL_KSEF_ACTIVATE', $moduleModel->getName(true)),
				'dataUrl' => 'index.php?module=' . $moduleModel->getName() . '&parent=' . $moduleModel->getParentName() . '&action=Activate',
				'linkdata' => ['confirm' => Language::translate('LBL_KSEF_ACTIVATE_CONFIRM', $moduleModel->getName(true))],
				'linkclass' => 'btn-primary btn-sm js-ksef-activate',
				'showLabel' => 1,
			];
		}

		return $basicLinks;
	}
}
