<?php

/**
 * Edit view file for Settings KSeF module.
 *
 * @package   Settings.View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

use App\Controller\ModalSettings;
use App\Request;

/**
 * Edit view class for Settings KSeF module.
 */
class Settings_KSeF_Edit_View extends ModalSettings
{
	/** {@inheritdoc} */
	public $showFooter = false;

	/** {@inheritdoc} */
	public $modalSize = 'modal-xl';

	/** {@inheritdoc} */
	public $successBtn = 'LBL_SAVE';

	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$record = !$request->isEmpty('record') ? $request->getInteger('record') : '';
		if ($record) {
			$recordModel = Settings_KSeF_Record_Model::getInstanceById($record);
		} else {
			$recordModel = Settings_KSeF_Record_Model::getCleanInstance();
		}
		$viewer = $this->getViewer($request);
		$viewer->assign('RECORD_MODEL', $recordModel);
		$viewer->assign('RECORD_ID', $record);
		$viewer->assign('MODULE_NAME', $request->getModule());
		$viewer->assign('BTN_SUCCESS', $this->successBtn);
		$viewer->assign('BTN_SUCCESS_ICON', $this->successBtnIcon);
		$viewer->assign('BTN_DANGER', $this->dangerBtn);
		$viewer->view('Edit/Modal.tpl', $request->getModule(false));
	}
}
