<?php
/**
 * PDF viewer widget file.
 *
 * @package Widget
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
/**
 * PDF viewer class.
 */
class Vtiger_PDFViewer_Widget extends Vtiger_Basic_Widget
{
	/**
	 * Custom widget fields.
	 *
	 * @var \Vtiger_Field_Model[]
	 */
	public $fields;

	/** {@inheritdoc} */
	public function isPermitted(): bool
	{
		return parent::isPermitted() && \App\YetiForce\Shop::check('YetiForceWidgets') && Users_Privileges_Model::getCurrentUserPrivilegesModel()->hasModuleActionPermission($this->Module, 'ExportPdf') && \Vtiger_PDF_Model::getTemplatesByModule($this->Module);
	}

	/** {@inheritdoc} */
	public function getWidget()
	{
		$this->Config['url'] = 'module=' . $this->Module . '&view=Detail&record=' . $this->Record . '&mode=showPDF';
		$this->Config['tpl'] = 'PDFViewerContainer.tpl';
		if (!empty($this->Data['action']) && $this->Record && ($fields = $this->getCustomFields())) {
			$this->Config['url'] .= '&template=' . $fields['template']->get('fieldvalue');
		}
		if (!empty($this->Data['height'])) {
			$this->Config['url'] .= '&height=' . $this->Data['height'];
		}

		return parent::getWidget();
	}

	/** {@inheritdoc} */
	public function getConfigTplName()
	{
		return 'PDFViewerConfig';
	}

	/**
	 * Gets custom fields.
	 *
	 * @return array
	 */
	public function getCustomFields(): array
	{
		if ($this->Record && !isset($this->fields)) {
			$this->fields = [];
			$handlerClass = \Vtiger_Loader::getComponentClassName('Model', 'PDF', $this->moduleModel->getName());
			$pdfModel = new $handlerClass();
			$params['uitype'] = 16;
			$params['picklistValues'] = [];
			$templates = $pdfModel->getActiveTemplatesForRecord($this->Record, 'Detail', $this->moduleModel->getName());
			foreach ($templates as $key => $pdfTemplate) {
				$params['picklistValues'][$key] = \App\Language::translate($pdfTemplate->get('primary_name'), $this->moduleModel->getName());
			}
			if (!empty($this->Data['action'])) {
				$params['fieldvalue'] = array_key_first($templates);
			}
			$this->fields['template'] = \Vtiger_Field_Model::init($this->moduleModel->getName(), $params, 'template');
		}

		return $this->fields ?? [];
	}

	/** {@inheritDoc} */
	public function validateData(array $data)
	{
		$height = $data['data']['height'] ?? null;
		if ($height && (!\is_int($height) || $height < 100 || $height > 2000)) {
			throw new \App\Exceptions\IllegalValue('ERR_NOT_ALLOWED_VALUE||height||' . $height, 406);
		}
	}
}
