'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";Vtiger_Detail_Js("Contacts_Detail_Js",{},{hierarchyResponseCache:{},/**
		 * Function to register recordpresave event
		 */registerRecordPreSaveEvent:function registerRecordPreSaveEvent(form){var primaryEmailField=jQuery("[name=\"email\"]");"undefined"==typeof form&&(form=this.getForm()),form.on(this.fieldPreSave,"[name=\"portal\"]",function(e){var portalField=jQuery(e.currentTarget),primaryEmailValue=primaryEmailField.val(),isAlertAlreadyShown=jQuery(".ui-pnotify").length;portalField.is(":checked")&&(0==primaryEmailField.length&&(0>=isAlertAlreadyShown&&app.showNotify({text:app.vtranslate("JS_PRIMARY_EMAIL_FIELD_DOES_NOT_EXISTS"),type:"error"}),e.preventDefault()),""==primaryEmailValue&&(0>=isAlertAlreadyShown&&app.showNotify({text:app.vtranslate("JS_PLEASE_ENTER_PRIMARY_EMAIL_VALUE_TO_ENABLE_PORTAL_USER"),type:"info"}),e.preventDefault()));});},/**
		 * Function to get response from hierarchy
		 * @param {array} params
		 * @returns {Promise}
		 */getHierarchyResponseData:function getHierarchyResponseData(params){var thisInstance=this,aDeferred=jQuery.Deferred();return $.isEmptyObject(thisInstance.hierarchyResponseCache)?AppConnector.request(params).then(function(data){thisInstance.hierarchyResponseCache=data,aDeferred.resolve(thisInstance.hierarchyResponseCache);}):aDeferred.resolve(thisInstance.hierarchyResponseCache),aDeferred.promise()},/**
		 * function to display the hierarchy response data
		 * @param {array} data
		 */displayHierarchyResponseData:function displayHierarchyResponseData(data){var callbackFunction=function(){app.showScrollBar($("#hierarchyScroll"),{height:"300px",railVisible:!0,size:"6px"});};app.showModalWindow(data,function(modalContainer){App.Components.Scrollbar.xy($("#hierarchyScroll",modalContainer)),"function"==typeof callbackFunction&&300<$("#hierarchyScroll",modalContainer).height()&&callbackFunction();});},/**
		 * Registers read count of hierarchy if it is possoble
		 */registerHierarchyRecordCount:function registerHierarchyRecordCount(){var hierarchyButton=$(".js-detail-hierarchy"),params={module:app.getModuleName(),action:"RelationAjax",record:app.getRecordId(),mode:"getHierarchyCount"};hierarchyButton.length&&AppConnector.request(params).then(function(response){response.success&&$(".hierarchy .badge").html(response.result);});},/**
		 * Shows hierarchy
		 */registerShowHierarchy:function registerShowHierarchy(){var thisInstance=this,hierarchyButton=$(".detailViewTitle"),params={module:app.getModuleName(),view:"Hierarchy",record:app.getRecordId()};hierarchyButton.on("click",".js-detail-hierarchy",function(){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});thisInstance.getHierarchyResponseData(params).then(function(data){thisInstance.displayHierarchyResponseData(data),progressIndicatorElement.progressIndicator({mode:"hide"});});});},/**
		 * Function which will register all the events
		 */registerEvents:function registerEvents(){var form=this.getForm();this._super(),this.registerHierarchyRecordCount(),this.registerShowHierarchy(),this.registerRecordPreSaveEvent(form);}});
//# sourceMappingURL=Detail.min.js.map
