'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _createForOfIteratorHelper(o,allowArrayLike){var it="undefined"!=typeof Symbol&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&"number"==typeof o.length){it&&(o=it);var i=0,F=function(){};return {s:F,n:function n(){return i>=o.length?{done:!0}:{done:!1,value:o[i++]}},e:function e(_e){throw _e},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var err,normalCompletion=!0,didErr=!1;return {s:function s(){it=it.call(o);},n:function n(){var step=it.next();return normalCompletion=step.done,step},e:function e(_e2){didErr=!0,err=_e2;},f:function f(){try{normalCompletion||null==it.return||it.return();}finally{if(didErr)throw err}}}}function _unsupportedIterableToArray(o,minLen){if(o){if("string"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return "Object"===n&&o.constructor&&(n=o.constructor.name),"Map"===n||"Set"===n?Array.from(o):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(o,minLen):void 0}}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}var Gantt=/*#__PURE__*/function(){/**
	 * Constructor
	 *
	 * @param {jQuery|HTMLElement|string} container
	 * @param {object} projectData
	 */function Gantt(container,projectData){_classCallCheck(this,Gantt),this.container=$(container),this.containerParent=this.container.parent(),this.headerContainer=this.containerParent.parent().find(".js-gantt-header").eq(0),this.weekStart=6-CONFIG.firstDayOfWeekNos;this.options={slots:{header:{beforeOptions:"<button class=\"btn btn-primary pb-2 mr-2 h-100 js-gantt__front-filter\"><span class=\"fas fa-filter\"></span> ".concat(LANG.JS_GANTT_FILTER,"</button>")}},maxRows:30,times:{timeZoom:20},calendar:{workingDays:[1,2,3,4,5]},title:{label:LANG.JS_GANTT_TITLE,html:!0},taskList:{expander:{straight:!1},columns:[{id:1,label:app.vtranslate("JS_NO."),html:!0,value:"number",width:65},{id:2,label:app.vtranslate("JS_NAME"),html:!0,value:"label",width:280,expander:!0},{id:3,label:app.vtranslate("JS_PRIORITY"),value:"priority_label",width:70},{id:3,label:app.vtranslate("JS_STATUS"),value:"status_label",width:80},{id:4,label:app.vtranslate("JS_DAYS"),value:function value(task){return task.duration/24/60/60/1e3},width:75,style:{"task-list-header-label":{"text-align":"center",width:"100%"},"task-list-item-value-container":{"text-align":"center",width:"100%"}}},{id:5,label:app.vtranslate("JS_PLANNED"),value:function value(task){return task.planned_duration},width:85,style:{"task-list-header-label":{"text-align":"center",width:"100%"},"task-list-item-value-container":{"text-align":"center",width:"100%"}}},{id:6,label:app.vtranslate("JS_REALISATION"),value:"sum_time",width:85,style:{"task-list-header-label":{"text-align":"center",width:"100%"},"task-list-item-value-container":{"text-align":"center",width:"100%"}}},{id:7,label:app.vtranslate("JS_ASSIGNED","Project"),value:"assigned_user_name",width:110},{id:8,label:"%",value:"progress",width:35,style:{"task-list-header-label":{"text-align":"center",width:"100%"},"task-list-item-value-container":{"text-align":"center",width:"100%"}}}]}},this.dynamicStyle={"chart-expander-wrapper":{"line-height":"1"},"chart-row-bar-polygon":{stroke:"#E74C3C00","stroke-width":0,fill:"#F75C4C"},"chart-row-progress-bar-outline":{stroke:"#E74C3C00","stroke-width":0},"chart-days-highlight-rect":{fill:"#f3f5f780"},"header-title":{float:"none",display:"inline-flex",overflow:"hidden"},"header-options":{float:"none",display:"inline-flex"},"header-title--html":{"white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis","padding-left":"0","letter-spacing":"0"},"slot-header-beforeOptions":{height:"100%","vertical-align":"top"}},this.registerLanguage(),"undefined"!=typeof projectData&&(this.options.title.label=projectData,this.loadProject(projectData)),this.registerEvents();}/**
	 * Register language translations globally (replace old ones)
	 */return _createClass(Gantt,[{key:"registerLanguage",value:function registerLanguage(){this.options.locale={name:CONFIG.langKey,weekStart:this.weekStart,weekdays:[LANG.JS_SUNDAY,LANG.JS_MONDAY,LANG.JS_TUESDAY,LANG.JS_WEDNESDAY,LANG.JS_THURSDAY,LANG.JS_FRIDAY,LANG.JS_SATURDAY],weekdaysShort:[LANG.JS_SUN,LANG.JS_MON,LANG.JS_TUE,LANG.JS_WED,LANG.JS_THU,LANG.JS_FRI,LANG.JS_SAT],weekdaysMin:[LANG.JS_SUN,LANG.JS_MON,LANG.JS_TUE,LANG.JS_WED,LANG.JS_THU,LANG.JS_FRI,LANG.JS_SAT],months:[LANG.JS_JANUARY,LANG.JS_FEBRUARY,LANG.JS_MARCH,LANG.JS_APRIL,LANG.JS_MAY,LANG.JS_JUNE,LANG.JS_JULY,LANG.JS_AUGUST,LANG.JS_SEPTEMBER,LANG.JS_OCTOBER,LANG.JS_NOVEMBER,LANG.JS_DECEMBER],monthsShort:[LANG.JS_JAN,LANG.JS_FEB,LANG.JS_MAR,LANG.JS_APR,LANG.JS_MAY,LANG.JS_JUN,LANG.JS_JUL,LANG.JS_AUG,LANG.JS_SEP,LANG.JS_OCT,LANG.JS_NOV,LANG.JS_DEC],ordinal:function ordinal(n){return "".concat(n)},Now:LANG.JS_GANTT_NOW,"X-Scale":LANG.JS_GANTT_ZOOM_X,"Y-Scale":LANG.JS_GANTT_ZOOM_Y,"Task list width":LANG.JS_GANTT_TASKLIST,"Before/After":LANG.JS_GANTT_EXPAND,"Display task list":LANG.JS_GANTT_TASKLIST_VISIBLE};}/**
	 * Filter project data
	 *
	 * @param {Object} _projectData
	 * @returns {Object}
	 */},{key:"filterProjectData",value:function filterProjectData(){var _this=this,tasks=this.allTasks.map(function(task){return Object.assign({},task)}),_loop=function _loop(moduleName){if(_this.filter.status.hasOwnProperty(moduleName)){var visibleLabels=_this.filter.status[moduleName].map(function(status){return status.label});tasks=tasks.filter(function(task){return task.module!==moduleName||0<=visibleLabels.indexOf(task.status_label)});}};for(var moduleName in this.filter.status)_loop(moduleName);return tasks}/**
	 * Add icons to tasks
	 * @param {array} tasks
	 * @returns {array}
	 */},{key:"addIcons",value:function addIcons(tasks){return tasks.map(function(task){var icon="briefcase";"milestone"===task.type?icon="folder":"task"===task.type&&(icon="file");var iconClass="fas fa-"+icon;return task.label="<span class=\"".concat(iconClass," fa-lg mr-1\"></span> ").concat(task.label),task})}/**
	 * Resize gantt chart
	 */},{key:"resize",value:function resize(){var offsetTop=this.container.offset().top,contentHeight=$("body").eq(0).height()-$(".js-footer").eq(0).height(),height=contentHeight-offsetTop-100;300>height&&(height=300),this.options.maxHeight=height,"undefined"!=typeof this.ganttState&&this.ganttState&&(this.ganttState.maxHeight=height);}/**
	 * Register gantt header actions
	 */},{key:"registerHeaderActions",value:function registerHeaderActions(){var _this2=this;this.headerContainer.find(".js-gantt-header__btn-filter").on("click",function(e){e.preventDefault(),_this2.showFiltersModal();}),this.headerContainer.find(".js-gantt-header__btn-center").on("click",function(e){_this2.ganttElastic.$emit("recenterPosition");}),this.headerContainer.find(".js-gantt-header__range-slider--x").on("input",function(e){_this2.ganttElastic.$emit("times-timeZoom-change",Number(e.target.value));}),this.headerContainer.find(".js-gantt-header__range-slider--y").on("input",function(e){_this2.ganttElastic.$emit("row-height-change",Number(e.target.value));}),this.headerContainer.find(".js-gantt-header__range-slider--task-list-width").on("input",function(e){_this2.ganttElastic.$emit("taskList-width-change",Number(e.target.value));}),this.headerContainer.find(".js-gantt-header__range-slider--scope").on("input",function(e){_this2.ganttElastic.$emit("scope-change",Number(e.target.value));}),this.headerContainer.find(".js-gantt-header__range-slider--task-list-visible").on("change",function(e){_this2.ganttState.options.taskList.display=$(e.target).is(":checked");}),this.ganttElastic.$watch("state.taskList.display",function(value){_this2.headerContainer.find(".js-gantt-header__range-slider--task-list-visible").prop("checked",value);}),this.headerContainer.find(".js-gantt-header__range-slider--task-list-visible").prop("checked",!!this.ganttState.options.taskList.display&&"checked");}/**
	 * Load project
	 */},{key:"loadProject",value:function loadProject(projectData){if(this.projectData=projectData,"undefined"==typeof this.projectData.tasks||0===this.projectData.tasks.length)return $(".js-hide-filter").addClass("d-none"),void $(".js-show-add-record").removeClass("d-none");this.allTasks=this.addIcons(this.projectData.tasks),this.statuses=this.projectData.statuses,this.filter={status:this.projectData.activeStatuses},this.container.closest("form").on("submit",function(ev){return ev.preventDefault(),ev.stopPropagation(),!1}),this.resize();var self=this;"undefined"==typeof self.ganttElastic?(this.ganttApp=GanttElastic.mount({el:"#"+this.container.attr("id"),data:{tasks:this.allTasks,options:this.options,dynamicStyle:this.dynamicStyle},ready:function ready(ganttElasticInstance){self.ganttElastic=ganttElasticInstance,self.ganttState=ganttElasticInstance.state,self.registerHeaderActions();}}),this.container=this.containerParent.find(".gantt-elastic").eq(0)):self.ganttApp.tasks=this.allTasks;}/**
	 * Load project from ajax request
	 * @param {object} params - request params such as module/action and projectId
	 */},{key:"loadProjectFromAjax",value:function loadProjectFromAjax(params){var self=this,progressInstance=jQuery.progressIndicator({blockInfo:{enabled:!0,onBlock:function onBlock(){AppConnector.request(params).done(function(response){self.loadProject(response.result),progressInstance.progressIndicator({mode:"hide"});});}}});}/**
	 * Load new data to gantt
	 *
	 * @param {Object} data
	 */},{key:"reloadData",value:function reloadData(data){this.loadProject(data);}/**
	 * Save filter and reload data.
	 *
	 * @param {Object} filterOptions
	 */},{key:"saveFilter",value:function saveFilter(filterOptions){this.filter=filterOptions,this.ganttApp.tasks=this.filterProjectData(this.projectData);}/**
	 * Get status from value (object with other props)
	 * @param {String} value
	 * @param {String} moduleName
	 * @returns {Object}
	 */},{key:"getStatusFromValue",value:function getStatusFromValue(value,moduleName){var _step,_iterator=_createForOfIteratorHelper(this.statuses[moduleName]);try{for(_iterator.s();!(_step=_iterator.n()).done;){var status=_step.value;if(status.value===value)return Object.assign({},status)}}catch(err){_iterator.e(err);}finally{_iterator.f();}app.errorLog("Status not found [".concat(value,"]"));}/**
	 * Open modal with status filters
	 */},{key:"showFiltersModal",value:function showFiltersModal(){var _this3=this,self=this;app.showModalHtml({headerIcon:"fas fa-filter",header:app.vtranslate("JS_FILTER_BY_STATUSES"),body:"<div class=\"js-gantt__filter-modal form\" data-js=\"container\">\n\t\t\t\t<div class=\"form-group\">\n\t\t\t\t\t<label>".concat(app.vtranslate("JS_PROJECT_STATUSES"),":</label>\n\t\t\t\t\t<select class=\"select2 form-control js-gantt__filter-project\"  multiple>\n\t\t\t\t\t\t").concat(self.statuses.Project.map(function(status){return "<option value=\"".concat(status.value,"\" ").concat(0<=_this3.filter.status.Project.map(function(status){return status.value}).indexOf(status.value)?"selected":"",">").concat(status.label,"</option>")}),"\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"form-group\">\n\t\t\t\t<label>").concat(app.vtranslate("JS_MILESTONE_STATUSES"),":</label>\n\t\t\t\t\t<select class=\"select2 form-control js-gantt__filter-milestone\" multiple>\n\t\t\t\t\t\t").concat(self.statuses.ProjectMilestone.map(function(status){return "<option value=\"".concat(status.value,"\" ").concat(0<=_this3.filter.status.ProjectMilestone.map(function(status){return status.value}).indexOf(status.value)?"selected":"",">").concat(status.label,"</option>")}),"\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"form-group\">\n\t\t\t\t<label>").concat(app.vtranslate("JS_TASK_STATUSES"),":</label>\n\t\t\t\t\t<select class=\"select2 form-control js-gantt__filter-task\" multiple>\n\t\t\t\t\t\t").concat(self.statuses.ProjectTask.map(function(status){return "<option value=\"".concat(status.value,"\" ").concat(0<=_this3.filter.status.ProjectTask.map(function(status){return status.value}).indexOf(status.value)?"selected":"",">").concat(status.label,"</option>")}),"\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t</div>"),footerButtons:[{text:app.vtranslate("JS_UPDATE_GANTT"),icon:"fas fa-check",class:"btn-primary js-success"},{text:app.vtranslate("JS_CANCEL"),icon:"fas fa-times",class:"btn-outline-primary",data:{dismiss:"modal"}}],cb:function cb(modal){modal.on("click",".js-success",function(e){self.saveFilter({status:{Project:modal.find(".js-gantt__filter-project").val().map(function(status){return self.getStatusFromValue(status,"Project")}),ProjectMilestone:modal.find(".js-gantt__filter-milestone").val().map(function(status){return self.getStatusFromValue(status,"ProjectMilestone")}),ProjectTask:modal.find(".js-gantt__filter-task").val().map(function(status){return self.getStatusFromValue(status,"ProjectTask")})}}),app.hideModalWindow();});}});}/**
	 * Register events for gantt actions in current container
	 */},{key:"registerEvents",value:function registerEvents(){var _this4=this,container=this.container;container.find("[data-toggle=\"tooltip\"]").tooltip(),window.addEventListener("resize",function(){_this4.resize();});}}])}();
//# sourceMappingURL=Gantt.min.js.map
