'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}var ReportTemplate_ConditionBuilder_Js=/*#__PURE__*/function(){/**
	 * Constructor
	 * @param {jQuery} container
	 * @param {(string|Object)} params
	 * @param {function} onChange
	 */function ReportTemplate_ConditionBuilder_Js(container,params,onChange){_classCallCheck(this,ReportTemplate_ConditionBuilder_Js),this.container=container,this.params="string"==typeof params?{sourceModuleName:params}:params,this.onChange=onChange?onChange:function(){};}/**
	 * Register change value event
	 *
	 * @param   {jQuery}  container
	 */return _createClass(ReportTemplate_ConditionBuilder_Js,[{key:"registerChangeValueEvent",value:function registerChangeValueEvent(container){var _this=this;container.find(".js-condition-builder-value").on("change",function(){_this.onChange(_this);});}/**
	 * Get default params
	 * @returns {Object}
	 */},{key:"getDefaultParams",value:function getDefaultParams(){return _objectSpread({module:app.getModuleName(),view:"Conditions"},this.params)}/**
	 * Register events when change conditions
	 * @param {jQuery} container
	 */},{key:"registerChangeConditions",value:function registerChangeConditions(container){var _this2=this,self=this;container.on("change",".js-conditions-fields, .js-conditions-operator",function(e){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),currentTarget=$(e.currentTarget),requestParams={};requestParams=currentTarget.hasClass("js-conditions-fields")?{fieldname:currentTarget.val()}:{fieldname:container.find(".js-conditions-fields").val(),operator:currentTarget.val()},AppConnector.request(_objectSpread(_objectSpread({},requestParams),_this2.getDefaultParams())).done(function(data){progress.progressIndicator({mode:"hide"}),container.html($(data).html()),self.registerField(container),self.registerChangeValueEvent(container),self.onChange(self);});});}/**
	 * register field types related events
	 * @param {jQuery} container
	 */},{key:"registerField",value:function registerField(container){App.Fields.Picklist.showSelect2ElementView(container.find("select.select2")),App.Fields.Date.register(container,!0,{},"js-date-field"),App.Fields.Date.registerRange(container.find(".js-date-range-field"),{ranges:!1}),App.Fields.DateTime.register(container.find(".js-datetime-range-field")),app.registerEventForClockPicker($(container.find(".clockPicker"))),App.Fields.Tree.register(container);}/**
	 * Register events to add condition
	 */},{key:"registerAddCondition",value:function registerAddCondition(){var _this3=this,self=this;this.container.on("click",".js-condition-add",function(e){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),container=$(e.currentTarget).closest(".js-condition-builder-group-container").find("> .js-condition-builder-conditions-container");AppConnector.request(_this3.getDefaultParams()).done(function(data){progress.progressIndicator({mode:"hide"}),data=$(data),App.Fields.Picklist.showSelect2ElementView(data.find("select.select2")),self.registerChangeConditions(data),self.registerChangeValueEvent(data),container.append(data),self.onChange(self);});});}/**
	 * Register events to add group
	 */},{key:"registerAddGroup",value:function registerAddGroup(){var _this4=this;this.container.on("click",".js-group-add",function(e){var template=_this4.container.find(".js-condition-builder-group-template").clone();template.removeClass("hide"),$(e.target).closest(".js-condition-builder-group-container").find("> .js-condition-builder-conditions-container").append(template.html()),_this4.onChange(_this4);});}/**
	 * Register events to remove group
	 */},{key:"registerDeleteGroup",value:function registerDeleteGroup(){var _this5=this;this.container.on("click",".js-group-delete",function(e){$(e.target).closest(".js-condition-builder-group-container").remove(),_this5.onChange(_this5);});}/**
	 * Register events to remove condition
	 */},{key:"registerDeleteCondition",value:function registerDeleteCondition(){var _this6=this;this.container.on("click",".js-condition-delete",function(e){$(e.target).closest(".js-condition-builder-conditions-row").remove(),_this6.onChange(_this6);});}/**
	 * Block submit on press enter key
	 */},{key:"registerDisableSubmitOnEnter",value:function registerDisableSubmitOnEnter(){this.container.find(".js-condition-builder-value").on("keydown",function(e){"Enter"===e.key&&e.preventDefault();});}/**
	 * Read conditions in group
	 * @param {jQuery} container
	 * @param {boolean} skipEmpty
	 * @returns {object}
	 */},{key:"readCondition",value:function readCondition(container,skipEmpty){var self=this,condition=container.find("> .js-condition-switch .js-condition-switch-value").hasClass("active")?"AND":"OR",arr={},rules=[];return container.find("> .js-condition-builder-conditions-container >").each(function(){var element=$(this);if(element.hasClass("js-condition-builder-conditions-row")){var _element$find$val;rules.push({field:element.find(".js-conditions-fields").val(),operator:element.find(".js-conditions-operator").val(),value:null!==(_element$find$val=element.find(".js-condition-builder-value").val())&&void 0!==_element$find$val?_element$find$val:"",subquery:null});}else if(element.hasClass("js-condition-builder-group-container")){var childRules=self.readCondition(element,skipEmpty);(!skipEmpty||Object.keys(childRules).length)&&rules.push(childRules);}}),(!skipEmpty||rules.length)&&(arr.condition=condition,arr.rules=rules),arr}/**
	 * Returns conditions
	 * @param {boolean} skipEmpty
	 * @returns {object}
	 */},{key:"getConditions",value:function getConditions(){var skipEmpty=!(0<arguments.length&&arguments[0]!==void 0)||arguments[0];return this.readCondition(this.container.find("> .js-condition-builder-group-container"),skipEmpty)}/**
	 * Main function to regsiter events
	 */},{key:"registerEvents",value:function registerEvents(){var self=this;this.registerAddCondition(),this.registerAddGroup(),this.registerDeleteGroup(),this.registerDeleteCondition(),this.registerDisableSubmitOnEnter(),this.container.find(".js-condition-builder-conditions-row").each(function(){var row=$(this);self.registerChangeConditions(row),self.registerChangeValueEvent(row),self.registerField(row);});}}])}();
//# sourceMappingURL=ConditionBuilder.min.js.map
