/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Settings_Vtiger_List_Js(
	'Settings_KSeF_List_Js',
	{},
	{
		/**
		 * Register events for buttons
		 */
		registerButtons() {
			this._super();
			this.registerCheckConnection();
			this.registerActivation();
		},

		/**
		 * Register check connection button
		 */
		registerCheckConnection() {
			const thisInstance = this;
			this.getListViewContainer().on('click', '.js-check-connection', function (e) {
				e.preventDefault();
				const recordId = $(this).data('record');
				thisInstance.checkConnection(recordId);
			});
		},
		registerActivation() {
			this.getListViewContainer().on('click', '.js-ksef-activate', (e) => {
				e.preventDefault();
				let url = e.currentTarget.dataset.url;
				let params = {
					text: e.currentTarget.dataset.confirm,
					title: e.currentTarget.dataset.content,
					confirmedCallback: () => {
						AppConnector.request(url)
							.done((data) => {
								console.log(data);
								if (data.result.success){
									app.showNotify({
										type: 'success',
										text: data.result.message
									});
									if (data.result._reload) {
										window.location.reload();
									}
								} else {
									app.showNotify({
										type: 'error',
										text: data.result.message
									});
								}
							})
							.fail(function (_error) {
								app.showError({
									title: app.vtranslate('JS_ERROR')
								});
							});
					}
				}
				app.showConfirmModal(params);
			});
		},

		/**
		 * Verify connection to KSeF API for given Settings record
		 *
		 * @param {int}  id
		 */
		checkConnection(id) {
			const thisInstance = this;
			const progressIndicatorElement = jQuery.progressIndicator({
				position: 'html',
				blockInfo: {
					enabled: true
				}
			});

			AppConnector.request({
				module: 'KSeF',
				parent: 'Settings',
				action: 'SaveAjax',
				mode: 'checkConnection',
				record: id
			})
			.done((data) => {
				progressIndicatorElement.progressIndicator({ mode: 'hide' });
				if (data.result.success){
					app.showNotify({
						type: 'success',
						text: data.result.message
					});
					if (data.result.reloadList) {
						thisInstance.getListViewRecords();
					}
				} else {
					app.showNotify({
						type: 'error',
						text: data.result.message
					});
				}
			})
			.fail(function (_error) {
				progressIndicatorElement.progressIndicator({ mode: 'hide' });
				app.showError({
					title: app.vtranslate('JS_ERROR')
				});
			});
		}
	},
	{}
);
