'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";jQuery.Class("Settings_Module_Import_Js",{},{/**
		 * Function to get import module step1 params
		 */getImportModuleStep1Params:function getImportModuleStep1Params(){var params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"ModuleImport"};return params},/**
		 * Function to get import module with respect to view
		 */getImportModuleStepView:function getImportModuleStepView(params){var aDeferred=jQuery.Deferred(),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject(error);}),aDeferred.promise()},/**
		 * Function to register event for step1 of import module
		 */registerEventForStep1:function registerEventForStep1(){var form=$(".js-validation-engine");form.validationEngine(),this.validationFileZipPath(form);var detailContentsHolder=jQuery(".contentsDiv");app.showScrollBar(jQuery(".extensionDescription"),{height:"120px",width:"100%",railVisible:!0}),this.registerEventsForImportModuleStep1(detailContentsHolder);},/**
		 * Function to validation file zip
		 */validationFileZipPath:function validationFileZipPath(form){form.on("submit",function(){if("undefined"!=typeof form.data("submit"))return !1;var filePath=form.find(".js-validation-zip").val(),fileParts=filePath.toLowerCase().split("."),fileType=fileParts[fileParts.length-1];if(""==fileType){var errorMessage=app.vtranslate("JS_IMPORT_FILE_CAN_NOT_BE_EMPTY");return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),!1}if("zip"!=fileType){var _errorMessage=app.vtranslate("JS_SELECT_FILE_EXTENSION")+"\n.zip";return Vtiger_Helper_Js.showMessage({text:_errorMessage,type:"error"}),!1}});},/**
		 * Function to register event related to Import extrension Modules in step1
		 */registerEventsForImportModuleStep1:function registerEventsForImportModuleStep1(container){var thisInstance=this;jQuery(container).find(".installExtension").on("click",function(e){var element=jQuery(e.currentTarget),extensionContainer=element.closest(".extension_container"),extensionId=extensionContainer.find("[name=\"extensionId\"]").val(),moduleAction=extensionContainer.find("[name=\"moduleAction\"]").val(),extensionName=extensionContainer.find("[name=\"extensionName\"]").val(),params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"ModuleImport",mode:"step2",extensionId:extensionId,moduleAction:moduleAction,extensionName:extensionName};thisInstance.getImportModuleStepView(params).done(function(data){var detailContentsHolder=jQuery(".contentsDiv");detailContentsHolder.html(data),app.showScrollBar(jQuery("#extensionLicense"),{height:"auto"}),thisInstance.registerEventsForImportModuleStep2(detailContentsHolder);});});},/**
		 * Function to register event related to Import extrension Modules in step2
		 */registerEventsForImportModuleStep2:function registerEventsForImportModuleStep2(container){container=jQuery(container);var thisInstance=this;container.find("#installExtension").on("click",function(){var extensionId=jQuery("[name=\"extensionId\"]").val(),targetModule=jQuery("[name=\"targetModule\"]").val(),moduleType=jQuery("[name=\"moduleType\"]").val(),moduleAction=jQuery("[name=\"moduleAction\"]").val(),fileName=jQuery("[name=\"fileName\"]").val(),params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"ModuleImport",mode:"step3",extensionId:extensionId,moduleAction:moduleAction,targetModule:targetModule,moduleType:moduleType,fileName:fileName};thisInstance.getImportModuleStepView(params).done(function(step3Data){app.showModalWindow({data:step3Data,unblockcb:function unblockcb(){container.find("#declineExtension").trigger("click");},css:{width:"60%",height:"40%"},cb:function callBackFunction(data){var installationStatus=jQuery(data).find("[name=\"installationStatus\"]").val();"success"==installationStatus&&jQuery("#installExtension").remove(),app.showScrollBar(jQuery("#installationLog"),{height:"150px"}),jQuery(data).find("#importCompleted").on("click",function(){container.find("#declineExtension").trigger("click");});}});});}),container.find("#declineExtension").on("click",function(){var params=thisInstance.getImportModuleStep1Params();thisInstance.getImportModuleStepView(params).done(function(data){var detailContentsHolder=jQuery(".contentsDiv");detailContentsHolder.html(data),thisInstance.registerEventForStep1();});});},registerEvents:function registerEvents(){this.registerEventForStep1(),$(".js-form-import-module").on("submit",function(){$(".js-save-button").attr("disabled",!0);});}}),jQuery(document).ready(function(){var settingModuleImportInstance=new Settings_Module_Import_Js;settingModuleImportInstance.registerEvents();});
//# sourceMappingURL=ModuleImport.min.js.map
