'use strict';

/**
 * SlaPolicy Edit Js class
 *
 * @package     Edit
 *
 * @description SlaPolicy Edit View scripts
 * @license     YetiForce Public License 7.0
 * @author      Rafal Pospiech <r.pospiech@yetiforce.com>
 */"use strict";$.Class("Settings_SlaPolicy_Edit_Js",{},{/**
		 * Register submit event
		 */registerSubmitEvent:function registerSubmitEvent(){var _this=this;this.container.off("submit").on("submit",function(e){return $(e.currentTarget).validationEngine("validate")?($("input[name=\"conditions\"]").val(JSON.stringify(_this.conditionBuilder.getConditions())),!0):(e.preventDefault(),e.stopPropagation(),!1)});},/**
		 * Load condition builder
		 *
		 * @param   {String}  sourceModuleName
		 */loadConditionBuilderView:function loadConditionBuilderView(sourceModuleName){var _this2=this;this.conditionBuilderView=this.container.find(".js-condition-builder-view").eq(0);var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"Conditions",record:sourceModuleName===this.sourceModuleName?this.record:0,sourceModuleName:sourceModuleName}).done(function(data){progress.progressIndicator({mode:"hide"}),_this2.conditionBuilderView.html(data),_this2.conditionBuilder=new Vtiger_ConditionBuilder_Js(_this2.conditionBuilderView.find(".js-condition-builder"),sourceModuleName),_this2.conditionBuilder.registerEvents();});},/**
		 * Register source module change
		 */registerSourceModuleChange:function registerSourceModuleChange(){var _this3=this;this.sourceModuleSelect=this.container.find("select[name=\"source_module\"]"),this.sourceModuleSelect.on("change",function(){_this3.sourceModuleName=_this3.sourceModuleSelect.val(),_this3.loadConditionBuilderView(_this3.sourceModuleName);});},/**
		 * Render business hours
		 *
		 * @param {Array} rows
		 * @returns {String} html
		 */renderBusinessHours:function renderBusinessHours(rows){var _this4=this,html="<table class=\"table table-sm js-business-hours-table\" data-js=\"container\">";return html+="<thead>\n\t\t\t\t<tr>\n\t\t\t\t\t<th colspan=\"6\" class=\"text-center\">".concat(app.vtranslate("JS_BUSINESS_HOURS"),"</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<th></th>\n\t\t\t\t\t<th>").concat(app.vtranslate("JS_BUSINESS_HOURS_NAME"),"</th>\n\t\t\t\t\t<th>").concat(app.vtranslate("JS_BUSINESS_HOURS_DAYS"),"</th>\n\t\t\t\t\t<th>").concat(app.vtranslate("JS_BUSINESS_HOURS_FROM"),"</th>\n\t\t\t\t\t<th>").concat(app.vtranslate("JS_BUSINESS_HOURS_TO"),"</th>\n\t\t\t\t</tr>\n\t\t\t</thead><tbody>"),rows.forEach(function(row){html+="<tr class=\"js-business-hours-row\" data-id=\"".concat(row.id,"\" data-js=\"click\">\n\t\t\t\t\t<td class=\"js-business-hours-table-id\"><input type=\"checkbox\" class=\"checkbox js-business-hours-checkbox\"").concat(-1===_this4.businessHours.indexOf(Number(row.id))?"":" checked=\"checked\"","></td>\n\t\t\t\t\t<td class=\"js-business-hours-table-name\">").concat(row.name,"</td>\n\t\t\t\t\t<td class=\"js-business-hours-table-days\">").concat(row.working_days).concat(row.holidays?", "+app.vtranslate("JS_HOLIDAYS"):"","</td>\n\t\t\t\t\t<td class=\"js-business-hours-table-from\">").concat(row.working_hours_from,"</td>\n\t\t\t\t\t<td class=\"js-business-hours-table-to\">").concat(row.working_hours_to,"</td>\n\t\t\t\t</tr>");}),html+"</tbody></table>"},/**
		 * Update business hours value inside hidden form input
		 */updateBusinessHoursValue:function updateBusinessHoursValue(){this.container.find("[name=\"business_hours\"]").val(this.businessHours.join(","));},/**
		 * Remove business hours
		 *
		 * @param {Number} businessHoursId
		 */removeBusinessHours:function removeBusinessHours(){var businessHoursId=0<arguments.length&&arguments[0]!==void 0?arguments[0]:0;-1!==this.businessHours.indexOf(businessHoursId)&&(this.businessHours=this.businessHours.filter(function(id){return id!==businessHoursId})),this.updateBusinessHoursValue();},/**
		 * Add business hours
		 *
		 * @param {Number} businessHoursId
		 */addBusinessHours:function addBusinessHours(businessHoursId){-1===this.businessHours.indexOf(businessHoursId)&&this.businessHours.push(businessHoursId),this.updateBusinessHoursValue();},/**
		 * On business hours row click event handler
		 */onBusinessHoursRowClick:function onBusinessHoursRowClick(e){e.stopPropagation();var target=$(e.target),isCheckbox=target.hasClass("js-business-hours-checkbox"),row=target.closest("tr"),id=Number(row.data("id")),checkbox=row.find("input[type=\"checkbox\"]");checkbox.prop("checked")?isCheckbox?this.addBusinessHours(id):(checkbox.prop("checked",!1),this.removeBusinessHours(id)):isCheckbox?this.removeBusinessHours(id):(checkbox.prop("checked",!0),this.addBusinessHours(id));},/**
		 * Register business hours table events
		 */registerBusinessHoursTableEvents:function registerBusinessHoursTableEvents(){var table=this.container.find(".js-business-hours-table").eq(0);table.find(".js-business-hours-row").on("click",this.onBusinessHoursRowClick.bind(this));},/**
		 * Change operational hours view
		 */changeOperationalHoursView:function changeOperationalHoursView(){var _this5=this;if(1===this.operationalHours){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({data:{module:"BusinessHours",parent:"Settings",view:"List"},dataType:"json"}).done(function(data){if(data.success){var rows=JSON.parse(data.result);_this5.container.find(".js-business-hours-container-content").html(_this5.renderBusinessHours(rows)),_this5.registerBusinessHoursTableEvents(),_this5.container.find(".js-business-hours-container").removeClass("d-none"),progress.progressIndicator({mode:"hide"});}});}else this.container.find(".js-business-hours-container").addClass("d-none");},/**
		 * Register operational hours change
		 */registerOperationalHoursChange:function registerOperationalHoursChange(){var _this6=this,operationalHoursElem=this.container.find("[name=\"operational_hours\"]").eq(0);operationalHoursElem.on("change",function(){_this6.operationalHours=Number(operationalHoursElem.val()),_this6.changeOperationalHoursView();});},/**
		 * Register events
		 */registerEvents:function registerEvents(){this.container=$("#EditView"),this.sourceModuleName=this.container.find("[name=\"source_module\"]").val(),this.operationalHours=Number(this.container.find("[name=\"operational_hours\"]").val()),this.businessHours=[];var hoursFromInput=this.container.find("[name=\"business_hours\"]").val();hoursFromInput&&(this.businessHours=hoursFromInput.split(",").map(function(id){return Number(id)})),this.record=this.container.find("input[name=\"record\"]").val(),this.registerSourceModuleChange(),this.loadConditionBuilderView(this.sourceModuleName),App.Fields.TimePeriod.register(this.container),this.changeOperationalHoursView(),this.registerOperationalHoursChange(),this.registerSubmitEvent(),this.container.validationEngine(app.validationEngineOptions);}});
//# sourceMappingURL=Edit.min.js.map
