'use strict';

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 ************************************************************************************/"use strict";$.Class("Vtiger_DashBoard_Js",{grid:!1,//static property which will store the instance of dashboard
currentInstance:!1,scrollContainer:!1,restrictContentDrag:function restrictContentDrag(container){container.on("mousedown.draggable",function(e){var element=$(e.target),isHeaderElement=!!(0<element.closest(".dashboardWidgetHeader").length);isHeaderElement||//Stop the event propagation so that drag will not start for contents
e.stopPropagation();});}},{container:!1,noCache:!1,instancesCache:{},init:function init(){Vtiger_DashBoard_Js.currentInstance=this;},/**
		 * Get container
		 * @returns JQuery
		 */getContainer:function getContainer(){return (!0==this.noCache||!1==this.container)&&(this.container=$(".grid-stack")),this.container},getCurrentDashboard:function getCurrentDashboard(){var dashboardId=$(".selectDashboard li a.active").closest("li").data("id");return dashboardId||(dashboardId=1),dashboardId},getWidgetInstance:function getWidgetInstance(widgetContainer){var id=widgetContainer.attr("id");if(this.noCache||!(id in this.instancesCache)){var widgetName=widgetContainer.data("name");this.instancesCache[id]=Vtiger_Widget_Js.getInstance(widgetContainer,widgetName);}return this.instancesCache[id]},registerGrid:function registerGrid(){var self=this;// recalculate positions with scrollbars
if(Vtiger_DashBoard_Js.grid=GridStack.init({margin:"5px",cellHeight:"70px",alwaysShowResizeHandle:/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)},".grid-stack"),Vtiger_DashBoard_Js.grid.on("change",function(){self.savePositions(self.getContainer().find(".grid-stack-item"));}),this.loadWidgets(),this.getContainer().width()!==this.getContainer().parent().width()){var parentWidth=self.getContainer().parent().width();this.getContainer().css("width",parentWidth+"px");}},/**
		 * Save widgets positions
		 * @param {JQuery} widgets
		 */savePositions:function savePositions(widgets){var widgetRowColPositions={},widgetSizes={};widgets.each(function(_index,element){var widget=$(element),widgetId=widget.find(".grid-stack-item-content").attr("id");widgetRowColPositions[widgetId]={row:widget.attr("gs-y"),col:widget.attr("gs-x")},widgetSizes[widgetId]={width:widget.attr("gs-w"),height:widget.attr("gs-h")};}),this.updateLazyWidget(),AppConnector.request({module:app.getModuleName(),action:"Widget",mode:"positions",position:widgetRowColPositions,size:widgetSizes});},updateLazyWidget:function updateLazyWidget(){var scrollTop=this.scrollContainer.scrollTop();this.scrollContainer.scrollTop(scrollTop+1).scrollTop(scrollTop);},loadWidgets:function loadWidgets(){var thisInstance=this;this.scrollContainer=App.Components.Scrollbar.page.element,Quasar.plugins.Platform.is.desktop||(this.scrollContainer=$(".bodyContent"),app.showNewScrollbar(this.scrollContainer)),thisInstance.getContainer().find(".dashboardWidget").Lazy({threshold:0,appendScroll:this.scrollContainer,widgetLoader:function widgetLoader(element){thisInstance.loadWidget(element);}}),this.updateLazyWidget();},loadWidget:function loadWidget(widgetContainer){var self=this,urlParams=widgetContainer.data("url"),mode=widgetContainer.data("mode"),moduleName=app.getModuleName(),sourceModule=$("a.active","ul.selectDashboradView").parent().data("module");if(widgetContainer.progressIndicator(),"open"===mode){var name=widgetContainer.attr("id"),userId=CONFIG.userId;if(1===widgetContainer.data("cache")){var cacheUrl=app.cacheGet(name+"_"+userId,!1);urlParams=cacheUrl?cacheUrl:urlParams;}AppConnector.request(urlParams).done(function(data){widgetContainer.html(data),App.Fields.Picklist.showSelect2ElementView(widgetContainer.find(".select2")),App.Fields.Tree.register(widgetContainer),self.getWidgetInstance(widgetContainer),widgetContainer.trigger(Vtiger_Widget_Js.widgetPostLoadEvent),self.adjustHeightWidget(widgetContainer),sourceModule&&moduleName!=sourceModule&&$(".js-widget-remove",widgetContainer).remove();}).fail(function(textStatus,errorThrown,errorObj){widgetContainer.progressIndicator({mode:"hide"}),CONFIG.debug&&widgetContainer.html(errorObj.responseText);var url=app.convertUrlToObject(urlParams);delete url.view,url.name,url.action="Widget",url.mode="remove",url=app.convertObjectToUrl(url),widgetContainer.prepend("<span style=\"float: right;\"><button class=\"btn btn-sm btn-light js-widget-remove\" data-url=\"".concat(url,"\" data-js=\"click\"><span class=\"fas fa-times\"></span></button></span>")),app.showNotify({title:app.vtranslate("JS_ERROR"),type:"error"});});}},/**
		 * Adjust the height of the widget.
		 * @param {jQuery} widgetContainer
		 */adjustHeightWidget:function adjustHeightWidget(widgetContainer){var headerHeight=widgetContainer.find(".dashboardWidgetHeader").outerHeight(),adjustedHeight=widgetContainer.height()-headerHeight;widgetContainer.find(".dashboardWidgetFooter").length&&(adjustedHeight-=widgetContainer.find(".dashboardWidgetFooter").outerHeight());var widgetContent=widgetContainer.find(".dashboardWidgetContent");widgetContent.css("max-height",adjustedHeight+"px"),app.showNewScrollbar(widgetContent,{wheelPropagation:!0});},registerRefreshWidget:function registerRefreshWidget(){var thisInstance=this;this.getContainer().on("click",".js-widget-refresh",function(e){var element=$(e.currentTarget);thisInstance.getWidgetInstance(element.closest(".dashboardWidget")).refreshWidget();});},removeWidget:function removeWidget(){var self=this;this.getContainer().on("click",".js-widget-remove",function(e){var element=$(e.currentTarget),listItem=$(element).parents(".grid-stack-item"),width=listItem.attr("gs-w"),height=listItem.attr("gs-h"),url=element.data("url"),parent=element.closest(".dashboardWidgetHeader").parent(),widgetTitle=parent.find(".js-widget__header__title").text().trim();app.showConfirmModal({title:"".concat(app.vtranslate("JS_ARE_YOU_SURE_TO_DELETE_WIDGET")," (").concat(widgetTitle,")<br>").concat(app.vtranslate("JS_ARE_YOU_SURE_TO_DELETE_WIDGET_INFO")),confirmedCallback:function confirmedCallback(){AppConnector.request(url).done(function(response){if(response.success){parent.fadeOut("slow",function(){parent.remove();}),Vtiger_DashBoard_Js.grid.removeWidget(listItem.get(0)),$(".js-widget-list").prev(".js-widget-predefined").removeClass("d-none");var data="<a class=\"js-widget-list__item dropdown-item d-flex\" href=\"#\"\n\t\t\t\t\t\t\t\t\t\tdata-widget-url=\"".concat(response.result.url,"\" data-linkid=\"").concat(response.result.linkid,"\"\n\t\t\t\t\t\t\t\t\t\tdata-name=\"").concat(response.result.name,"\" data-width=\"").concat(width,"\" data-height=\"").concat(height,"\"\n\t\t\t\t\t\t\t\t\t\tdata-js=\"remove | click\">").concat(response.result.title);response.result.deleteFromList&&(data+="<span class=\"text-danger pl-5 ml-auto\"><span class=\"fas fa-trash-alt removeWidgetFromList u-hover-opacity\" data-widget-id=\"".concat(response.result.id,"\" data-js=\"click\"></span></span>")),data+="</a>";var divider=$(".js-widget-list .dropdown-divider");divider.length?$(data).insertBefore(divider):$(".js-widget-list").append(data),self.updateLazyWidget(),self.showAndHideAlert(!1);}});}});});},registerSelectDashboard:function registerSelectDashboard(){var thisInstance=this;$(".selectDashboard li").on("click",function(e){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),currentTarget=$(e.currentTarget),dashboardId=currentTarget.data("id"),params={module:app.getModuleName(),view:app.getViewName(),dashboardId:dashboardId};AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),$(".dashboardViewContainer").html(data),thisInstance.noCache=!0,thisInstance.registerEvents();});});},registerDatePickerHideInitiater:function registerDatePickerHideInitiater(){var container=this.getContainer();container.on("click","input.dateRange",function(e){var widgetContainer=$(e.currentTarget).closest(".dashboardWidget"),dashboardWidgetHeader=$(".dashboardWidgetHeader",widgetContainer);//adding clickoutside event on the dashboardWidgetHeader
return Vtiger_Helper_Js.addClickOutSideEvent(dashboardWidgetHeader.find(".dateRange"),function callbackFunction(){var date=$(".dateRange");date.DatePickerHide(),date.blur();}),!1});},registerShowMailBody:function registerShowMailBody(){var container=this.getContainer();container.on("click",".showMailBody",function(e){var widgetContainer=$(e.currentTarget).closest(".mailRow"),mailBody=widgetContainer.find(".mailBody"),bodyIcon=$(e.currentTarget).find(".body-icon");"none"==mailBody.css("display")?(mailBody.show(),bodyIcon.removeClass("fa-chevron-down").addClass("fa-chevron-up")):(mailBody.hide(),bodyIcon.removeClass("fa-chevron-up").addClass("fa-chevron-down"));});},registerMiniListWidget:function registerMiniListWidget(){var thisInstance=this;$(".dashboardHeading").off("click",".js-add-filter").on("click",".js-add-filter",function(e){var element=$(e.currentTarget);app.showModalWindow(null,"index.php?module=Home&view=MiniListWizard&step=step1",function(wizardContainer){var form=$("form",wizardContainer);form.on("keypress",function(event){return 13!=event.keyCode});var moduleNameSelectDOM=$("select[name=\"module\"]",wizardContainer),filteridSelectDOM=$("select[name=\"filterid\"]",wizardContainer),fieldHrefDOM=$("select[name=\"field_href\"]",wizardContainer),fieldsSelectDOM=$("select[name=\"fields\"]",wizardContainer),filterFieldsSelectDOM=$("select[name=\"filter_fields\"]",wizardContainer),moduleNameSelect2=App.Fields.Picklist.showSelect2ElementView(moduleNameSelectDOM,{placeholder:app.vtranslate("JS_SELECT_MODULE")}),filteridSelect2=App.Fields.Picklist.showSelect2ElementView(filteridSelectDOM,{placeholder:app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_OPTION"),dropdownParent:wizardContainer}),fieldHrefSelect2=App.Fields.Picklist.showSelect2ElementView(fieldHrefDOM,{allowClear:!0}),fieldsSelect2=App.Fields.Picklist.showSelect2ElementView(fieldsSelectDOM,{placeholder:app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_OPTION"),closeOnSelect:!0,maximumSelectionLength:6}),filterFieldsSelect2=App.Fields.Picklist.showSelect2ElementView(filterFieldsSelectDOM,{placeholder:app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_OPTION")}),footer=$(".modal-footer",wizardContainer);filteridSelectDOM.closest("tr").hide(),fieldsSelectDOM.closest("tr").hide(),fieldHrefDOM.closest("tr").hide(),footer.hide(),moduleNameSelect2.on("change",function(){moduleNameSelect2.val()&&(footer.hide(),fieldsSelectDOM.closest("tr").hide(),AppConnector.request({module:"Home",view:"MiniListWizard",step:"step2",selectedModule:moduleNameSelect2.val()}).done(function(res){filteridSelectDOM.empty().html(res).trigger("change"),filteridSelect2.closest("tr").show();}));}),filteridSelect2.on("change",function(){filteridSelect2.val()&&AppConnector.request({module:"Home",view:"MiniListWizard",step:"step3",selectedModule:moduleNameSelect2.val(),filterid:filteridSelect2.val()}).done(function(res){var responseHTML=$(res),fieldsHTML=responseHTML.find("select[name=\"fields\"]").html(),filterFieldsHTML=responseHTML.find("select[name=\"filter_fields\"]").html();fieldsSelectDOM.empty().html(fieldsHTML).trigger("change"),fieldsSelect2.closest("tr").show(),fieldsSelect2.data("select2").$selection.find(".select2-search__field").parent().css("width","100%"),filterFieldsSelectDOM.empty().html(filterFieldsHTML).trigger("change"),filterFieldsSelect2.closest("tr").show(),filterFieldsSelect2.data("select2").$selection.find(".select2-search__field").parent().css("width","100%"),fieldHrefSelect2.closest("tr").show();});}),fieldsSelect2.on("change",function(){fieldHrefDOM.find("option:not([value=\"\"]").remove(),$(this).find("option:checked").each(function(index,element){var option=$(element),newOption=new Option(option.text(),option.val(),!0,!0);fieldHrefSelect2.append(newOption);}),fieldHrefSelect2.val("").trigger("change"),fieldsSelect2.val()?footer.show():footer.hide();}),form.validationEngine(app.validationEngineOptions),form.on("submit",function(e){if(e.preventDefault(),!0===form.validationEngine("validate")){var selectedFields=[];fieldsSelect2.select2("data").map(function(obj){selectedFields.push(obj.id);}),thisInstance.saveMiniListWidget({module:moduleNameSelect2.val(),fields:selectedFields,filterFields:filterFieldsSelect2.val(),fieldHref:fieldHrefSelect2.val()},element,moduleNameSelect2.find(":selected").text(),filteridSelect2.val(),filteridSelect2.find(":selected").text(),form);}});});});},saveMiniListWidget:function saveMiniListWidget(data,element,moduleNameLabel,filterid,filterLabel,form){var thisInstance=this,paramsForm={data:JSON.stringify(data),blockid:element.data("block-id"),linkid:element.data("linkid"),label:moduleNameLabel+" - "+filterLabel,title:form.find("[name=\"widgetTitle\"]").val(),name:"Mini List",filterid:filterid,isdefault:0,height:4,width:4,owners_all:["mine","all","users","groups"],default_owner:"mine",dashboardId:thisInstance.getCurrentDashboard()},sourceModule=$("[name=\"selectedModuleName\"]").val();thisInstance.saveWidget(paramsForm,"add",sourceModule,paramsForm.linkid,"MiniList").done(function(data){var result=data.result,params={};if(data.success){app.hideModalWindow(),paramsForm.id=result.id,paramsForm.status=result.status,params.text=result.text,params.type="success";var linkElement=element.clone();linkElement.data("name","MiniList"),linkElement.data("id",result.wid),thisInstance.addWidget(linkElement,"index.php?module=Home&view=ShowWidget&name=MiniList&linkid="+element.data("linkid")+"&widgetid="+result.wid+"&active=0"),Vtiger_Helper_Js.showMessage(params);}else {var errorField,message=data.error.message;errorField=513==data.error.code?form.find("[name=\"fieldLabel\"]"):form.find("[name=\"fieldName\"]"),errorField.validationEngine("showPrompt",message,"error","topLeft",!0);}});},saveWidget:function saveWidget(form,mode,sourceModule,linkid,type){var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});"undefined"==typeof sourceModule&&(sourceModule=app.getModuleName());var params={form:form,module:app.getModuleName(),sourceModule:sourceModule,action:"Widget",mode:mode,addToUser:!0,linkid:linkid,name:type};return AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject(error);}),aDeferred.promise()},registerTabModules:function registerTabModules(){var thisInstance=this;$(".selectDashboradView li").on("click",function(e){var currentTarget=$(e.currentTarget);$(".selectDashboradView li").removeClass("active"),currentTarget.addClass("active");var params={module:currentTarget.data("module"),view:app.getViewName(),sourceModule:app.getModuleName(),dashboardId:thisInstance.getCurrentDashboard()};AppConnector.request(params).done(function(data){$(".dashboardViewContainer").html(data),thisInstance.noCache=!0,thisInstance.registerEvents();});});},/**
		 * Remove widget from list
		 */removeWidgetFromList:function removeWidgetFromList(){var thisInstance=this;$(".dashboardHeading").on("click",".removeWidgetFromList",function(e){var currentTarget=$(e.currentTarget),id=currentTarget.data("widget-id"),params={module:app.getModuleName(),action:"Widget",mode:"removeWidgetFromList",widgetid:id};AppConnector.request(params).done(function(){var params={text:app.vtranslate("JS_WIDGET_DELETED"),type:"success"};Vtiger_Helper_Js.showMessage(params),currentTarget.closest(".js-widget-list__item").remove(),1>$(".js-widget-list .js-widget-list__item").length&&$(".js-widget-list").prev(".js-widget-predefined").addClass("d-none"),thisInstance.updateLazyWidget();});});},/**
		 * Updates tablet scroll top position
		 */registerTabletScrollEvent:function registerTabletScrollEvent(){var _this=this;if(app.touchDevice&&Quasar.plugins.Platform.is.desktop){var scollbarContainer=$(".js-tablet-scroll");scollbarContainer.parent().removeClass("d-none");var scollbarContainerH=scollbarContainer.outerHeight(),scollbarOffsetTop=scollbarContainer.offset().top,maxOffset=$(".js-header").outerHeight()+8;this.scrollContainer.on("scroll",function(){_this.scrollContainer.scrollTop()+maxOffset>=scollbarOffsetTop?scollbarContainer.css({top:maxOffset}):scollbarContainer.css({top:scollbarOffsetTop-_this.scrollContainer.scrollTop(),height:scollbarContainerH+_this.scrollContainer.scrollTop()});});}},/**
		 * Updates list of predefined widgets after changed dashboard
		 */registerUpdatePredefinedWidgets:function registerUpdatePredefinedWidgets(){var _this2=this,container=$(".js-predefined-widgets");container.off("click",".js-widget-list__item"),container.on("click",".js-widget-list__item",function(e){$(e.target).hasClass("removeWidgetFromList")||_this2.addWidget($(e.currentTarget),$(e.currentTarget).data("widgetUrl"));}),AppConnector.request({view:"BasicAjax",mode:"getDashBoardPredefinedWidgets",module:app.getModuleName(),dashboardId:this.getCurrentDashboard()}).done(function(data){container.html(data);});},addWidget:function addWidget(element,url){element=$(element);var linkId=element.data("linkid"),name=element.data("name"),widgetId=element.data("id");element.remove(),1>$(".js-widget-list .js-widget-list__item").length&&$(".js-widget-list").prev(".js-widget-predefined").addClass("d-none");var widget=Vtiger_DashBoard_Js.grid.addWidget("<div class=\"grid-stack-item js-css-element-queries\" data-js=\"css-element-queries\"><div id=\"".concat(linkId,"-").concat(widgetId,"\" data-name=\"").concat(name,"\" data-mode=\"open\" class=\"grid-stack-item-content dashboardWidget new\" data-url=\"").concat(url,"\"></div></div>"),{w:element.data("width"),h:element.data("height"),auto_position:!0});Vtiger_DashBoard_Js.currentInstance.loadWidget($(widget).find(".grid-stack-item-content")),this.showAndHideAlert("addWidget");},/**
		 * Show or hide the alert for a dashboard.
		 * @param {string} widgetAction
		 */showAndHideAlert:function showAndHideAlert(widgetAction){var container=this.getContainer(),alertContainer=container.find(".js-dashboards-alert");"addWidget"===widgetAction?alertContainer.addClass("d-none"):0==container.find(".js-css-element-queries").length&&alertContainer.removeClass("d-none");},registerEvents:function registerEvents(){this.registerGrid(),this.registerRefreshWidget(),this.removeWidget(),this.registerDatePickerHideInitiater(),this.registerShowMailBody(),this.registerMiniListWidget(),this.registerTabModules(),this.removeWidgetFromList(),this.registerSelectDashboard(),this.registerTabletScrollEvent(),this.registerUpdatePredefinedWidgets(),ElementQueries.listen();}});
//# sourceMappingURL=DashBoard.min.js.map
