'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/** Class representing a calendar. */var _Class;function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}window.Calendar_Js=(_Class=/*#__PURE__*/function(){/**
	 * Create calendar's options.
	 * @param {jQuery} container
	 * @param {bool} readonly
	 * @param {boolean} browserHistory
	 */function _Class(){var _this=this,container=0<arguments.length&&arguments[0]!==void 0?arguments[0]:$(".js-base-container"),readonly=!!(1<arguments.length&&arguments[1]!==void 0)&&arguments[1],browserHistory=!(2<arguments.length&&arguments[2]!==void 0)||arguments[2];_classCallCheck(this,_Class),this.calendarCreateView=!1,this.container=container,this.calendarView=container.find(".js-calendar__container"),this.readonly=readonly,this.eventCreate=app.getMainParams("eventCreate"),this.eventEdit=app.getMainParams("eventEdit"),this.browserHistory=!readonly&&browserHistory,this.sidebarView={length:0},this.startHour=app.getMainParams("startHour"),this.endHour=app.getMainParams("endHour"),""==this.startHour&&(this.startHour="00"),""==this.endHour&&(this.endHour="00"),this.browserHistoryOptions={},this.browserHistoryConfig=this.browserHistory?this.setBrowserHistoryOptions():{},this.calendarOptions=this.setCalendarOptions(),this.eventTypeKeyName=!1,this.module=app.getModuleName(),app.event.on("QuickEdit.AfterSaveFinal",function(){_this.reloadCalendarData();});}/**
	 * Set calendar's options.
	 * @returns {object}
	 */return _createClass(_Class,[{key:"setCalendarOptions",value:function setCalendarOptions(){return Object.assign(this.setCalendarBasicOptions(),this.setCalendarAdvancedOptions(),this.setCalendarModuleOptions(),this.browserHistoryOptions)}/**
	 * Set calendar's basic options.
	 * @returns {object}
	 */},{key:"setCalendarBasicOptions",value:function setCalendarBasicOptions(){var eventLimit=app.getMainParams("eventLimit"),userView=app.getMainParams("activity_view"),defaultView=app.moduleCacheGet("defaultView"),userTimeFormat=CONFIG.hourFormat;eventLimit=!("true"!=eventLimit)||"false"!=eventLimit&&parseInt(eventLimit)+1,userView="Today"===userView?app.getMainParams("dayView"):"This Week"===userView?app.getMainParams("weekView"):"This Year"===userView?"year":"dayGridMonth",null!=defaultView&&(userView=defaultView),userTimeFormat=24==userTimeFormat?{hour:"2-digit",minute:"2-digit",hour12:!1,meridiem:!1}:{hour:"numeric",minute:"2-digit",meridiem:"short"};var options={eventTimeFormat:userTimeFormat,slotLabelFormat:userTimeFormat,initialView:Calendar_Js.viewsNamesMap[userView]?Calendar_Js.viewsNamesMap[userView]:userView,forceEventDuration:!0,defaultTimedEventDuration:"01:00:00",dayMaxEvents:eventLimit,selectMirror:!0,slotDuration:"00:15:00",nowIndicator:!0,scrollTime:this.startHour+":00"};if(null!==app.moduleCacheGet("start")&&app.moduleCacheGet("start")!==void 0)try{var s=App.Fields.Date.getDateInstance(app.moduleCacheGet("start")),e=App.Fields.Date.getDateInstance(app.moduleCacheGet("end"));options.initialDate=App.Fields.Date.dateToDbFormat(new Date(e-(e-s)/2));}catch(_error){app.cacheClear(app.getModuleName()+"_start"),app.cacheClear(app.getModuleName()+"_end");}return Object.assign(this.setCalendarMinimalOptions(),options)}/**
	 * Set calendar's minimal options.
	 * @returns {object}
	 */},{key:"setCalendarMinimalOptions",value:function setCalendarMinimalOptions(){var _this2=this,hiddenDays=[];return "workDays"===app.getMainParams("switchingDays")&&(hiddenDays=app.getMainParams("hiddenDays",!0)),{navLinks:!0,firstDay:CONFIG.firstDayOfWeekNo,selectable:!0,hiddenDays:hiddenDays,moreLinkContent:app.vtranslate("JS_MORE"),allDayText:app.vtranslate("JS_ALL_DAY"),noEventsText:app.vtranslate("JS_NO_RECORDS"),buttonText:{today:"",year:app.vtranslate("JS_YEAR"),week:app.vtranslate("JS_WEEK"),month:app.vtranslate("JS_MONTH"),day:app.vtranslate("JS_DAY"),dayGridMonth:app.vtranslate("JS_MONTH"),dayGridWeek:app.vtranslate("JS_WEEK"),listWeek:app.vtranslate("JS_WEEK"),dayGridDay:app.vtranslate("JS_DAY"),timeGridDay:app.vtranslate("JS_DAY"),list:app.vtranslate("JS_CALENDAR_LIST")},buttonHints:{prev:function prev(buttonText){return "".concat(app.vtranslate("JS_PREV")," ").concat(buttonText)},next:function next(buttonText){return "".concat(app.vtranslate("JS_NEXT")," ").concat(buttonText)},today:function today(buttonText){return "".concat(app.vtranslate("JS_CURRENT")," ").concat(buttonText)}},viewHint:"$0",navLinkHint:function navLinkHint(_dateStr,zonedDate){return App.Fields.Date.dateToUserFormat(zonedDate)},dayHeaderContent:function dayHeaderContent(arg){var dayOfTheWeek=arg.date.getDay();return "dayGridMonth"===arg.view.type&&(dayOfTheWeek=arg.date.getUTCDay()),600>_this2.container.width()?App.Fields.Date.daysTranslated[dayOfTheWeek]:App.Fields.Date.fullDaysTranslated[dayOfTheWeek]},eventDataTransform:function eventDataTransform(event){return event.allDay&&(event.end=moment(event.end).add(1,"days").format("YYYY-MM-DD")),event}}}/**
	 * Set calendar's advanced options.
	 * @returns {object}
	 */},{key:"setCalendarAdvancedOptions",value:function setCalendarAdvancedOptions(){var _this3=this,self=this;return {editable:!this.readonly&&1==this.eventEdit,selectable:!this.readonly&&1==this.eventCreate,headerToolbar:{left:"dayGridMonth,"+app.getMainParams("weekView")+","+app.getMainParams("dayView"),center:"title,today",right:"prev,next"},allDaySlot:app.getMainParams("allDaySlot"),views:{basic:{dayMaxEvents:!1},dayGridMonth:{titleFormat:function titleFormat(args){return _this3.formatDate(args.date,args.end,"month")}},timeGridWeek:{titleFormat:function titleFormat(args){return _this3.formatDate(args.date,args.end,"week")}},timeGridDay:{titleFormat:function titleFormat(args){return _this3.formatDate(args.date,args.end,"day")}},listWeek:{titleFormat:function titleFormat(args){return _this3.formatDate(args.date,args.end,"week")},dayHeaderContent:function dayHeaderContent(arg){return {html:"<span class=\"fc-list-day-text\">".concat(App.Fields.Date.fullDaysTranslated[arg.date.getDay()],"</span>\n\t\t\t\t\t\t\t<span class=\"fc-list-day-side-text\">").concat(App.Fields.Date.dateToUserFormat(arg.date),"</span>")}}},basicDay:{type:"timeGridDay"}},eventDrop:self.updateEvent,eventResize:self.updateEvent,datesSet:function datesSet(dateInfo){app.event.trigger("Calendar.DatesSet",dateInfo,_this3),self.loadCalendarData();},eventContent:self.eventRenderer,height:this.setCalendarHeight()}}/**
	 * Set calendar module's options.
	 * @returns {object}
	 */},{key:"setCalendarModuleOptions",value:function setCalendarModuleOptions(){return {}}/**
	 * Invokes FullCalendar with options.
	 */},{key:"renderCalendar",value:function renderCalendar(){this.fullCalendar=new FullCalendar.Calendar(this.calendarView.get(0),this.calendarOptions),this.fullCalendar.render(),this.registerViewRenderEvents();}/**
	 * Get calendar container.
	 * @returns {(boolean|jQuery)}
	 */},{key:"getCalendarView",value:function getCalendarView(){return this.calendarView||(this.calendarView=this.container.find(".js-calendar__container")),this.calendarView}/**
	 * Load calendar data
	 */},{key:"loadCalendarData",value:function loadCalendarData(){var _this4=this,defaultParams=this.getDefaultParams();if(this.fullCalendar.removeAllEvents(),!defaultParams.emptyFilters){var progressInstance=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request(defaultParams).done(function(events){_this4.fullCalendar.addEventSource(events.result),progressInstance.progressIndicator({mode:"hide"});});}}/**
	 * Reload calendar data after changing search parameters
	 */},{key:"reloadCalendarData",value:function reloadCalendarData(){this.loadCalendarData();}/**
	 * Default params
	 * @returns {{module: string, action: string, mode: string, start: string, end: string, user: *, cvid: int, emptyFilters: boolean}}
	 */},{key:"getDefaultParams",value:function getDefaultParams(){var users=app.moduleCacheGet("calendar-users")||CONFIG.userId,sideBar=this.getSidebarView(),filters=[],params={module:this.module?this.module:CONFIG.module,action:"Calendar",mode:"getEvents",start:App.Fields.Date.dateToUserFormat(this.fullCalendar.view.activeStart),end:App.Fields.Date.dateToUserFormat(this.fullCalendar.view.activeEnd),user:users,cvid:this.getCurrentCvId(),emptyFilters:0===users.length};return sideBar.find(".calendarFilters .filterField").each(function(){var name,value,element=$(this);"checkbox"==element.attr("type")?(name=element.val(),value=element.prop("checked")?1:0):(name=element.attr("name"),value=element.val()),filters.push({name:name,value:value});}),filters.length&&(params.filters=filters),sideBar.find(".js-sidebar-filter-container").each(function(_,e){var element=$(e),name=element.data("name"),cacheName=element.data("cache");name&&cacheName&&app.moduleCacheGet(cacheName)&&(params[name]=app.moduleCacheGet(cacheName),params.emptyFilters=!params.emptyFilters&&0===params[name].length);}),sideBar.find(".js-filter__container_checkbox_list").each(function(_,e){var filters=[],element=$(e),name=element.data("name");element.find(".js-filter__item__val:checked").each(function(){filters.push($(this).val());}),name&&(params[name]=filters);}),sideBar.find(".js-calendar__filter__select").each(function(_,e){var element=$(e),name=element.attr("name"),cacheName=element.data("cache");name&&(params[name]=cacheName&&app.moduleCacheGet(cacheName)?app.moduleCacheGet(cacheName):element.val(),params.emptyFilters=!params.emptyFilters&&0===params[name].length);}),params}/**
	 * Converts the date format.
	 * @param {object} startDate
	 * @param {object} endDate
	 * @param {string} type
	 * @returns {string}
	 */},{key:"formatDate",value:function formatDate(startDate,endDate,type){switch(type){case"month":return Calendar_Js.monthFormat[CONFIG.dateFormat].replace("YYYY",startDate.year).replace("MMMM",App.Fields.Date.fullMonthsTranslated[startDate.month]);case"week":var weekRange="",endMonth="",startDay=startDate.day,endYear=startDate.year;return startDate.month!==endDate.month&&(endMonth=App.Fields.Date.monthsTranslated[endDate.month]),startDate.year!==endDate.year&&(startDay=startDate.day+", "+startDate.year,endYear=endDate.year),weekRange=[App.Fields.Date.monthsTranslated[startDate.month],startDay,"-",endMonth,endDate.day+",",endYear].join(" "),weekRange;case"day":return CONFIG.dateFormat.replace("yyyy",startDate.year).replace("mm",App.Fields.Date.monthsTranslated[startDate.month]).replace("dd",startDate.day)}}/**
	 * Update calendar's event.
	 * @param {Object} info
	 */},{key:"updateEvent",value:function updateEvent(info){var progressInstance=jQuery.progressIndicator({blockInfo:{enabled:!0}}),start=info.event.start,end=info.event.end,allDay=info.event.allDay;allDay&&"object"===_typeof(end)&&end.setDate(end.getDate()-1),AppConnector.request({module:this.module?this.module:CONFIG.module,action:"Calendar",mode:"updateEvent",id:info.event.id,start:App.Fields.DateTime.dateToUserFormat(start),end:App.Fields.DateTime.dateToUserFormat(end),allDay:allDay}).done(function(response){progressInstance.progressIndicator({mode:"hide"}),response.result?window.popoverCache={}:(app.showNotify({text:app.vtranslate("JS_NO_EDIT_PERMISSION"),type:"error"}),info.revert());}).fail(function(){progressInstance.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_NO_EDIT_PERMISSION"),type:"error"}),info.revert();});}/**
	 * Render event.
	 * @param {Object} arg
	 * @returns {Object}
	 */},{key:"eventRenderer",value:function eventRenderer(arg){if("background"===arg.event.display)return {html:"<span class=\"".concat(arg.event.extendedProps.icon," js-popover-icon mr-1\"></span>").concat(arg.event._def.title)}}/**
	 * Returns counted calendar height.
	 * @returns {(number|string)}
	 */},{key:"setCalendarHeight",value:function setCalendarHeight(){var _this5=this,defaultHeightValue="auto";if(993<$(window).width()){var calendarPadding=this.container.hasClass("js-modal-container")?this.container.find(".js-modal-header").outerHeight():this.container.find(".js-contents-div").css("margin-left").replace("px","");var setCalendarH=function(){return $(window).height()-_this5.container.find(".js-calendar__container").offset().top-$(".js-footer").height()-calendarPadding};defaultHeightValue=setCalendarH(),new ResizeSensor(this.container.find(".contentsDiv"),function(){var currentHeight=setCalendarH();currentHeight!==defaultHeightValue&&_this5.fullCalendar.setOption("height",currentHeight);});}return defaultHeightValue}/**
	 * Set calendar options from browser history.
	 * @returns {object}
	 */},{key:"setBrowserHistoryOptions",value:function setBrowserHistoryOptions(){var _this6=this,historyParams=app.getMainParams("historyParams",!0),options={};if(historyParams&&(historyParams.length||Object.keys(historyParams).length)){var s=App.Fields.Date.getDateInstance(historyParams.start),e=App.Fields.Date.getDateInstance(historyParams.end);this.browserHistoryOptions={initialView:historyParams.viewType,initialDate:App.Fields.Date.dateToDbFormat(new Date(e-(e-s)/2)),hiddenDays:historyParams.hiddenDays.split(",").map(function(x){var parsedValue=parseInt(x);return isNaN(parsedValue)?"":parsedValue})},options={start:historyParams.start,end:historyParams.end,time:historyParams.time,user:historyParams.user,cvid:historyParams.cvid},Object.keys(options).forEach(function(key){return "undefined"===options[key]&&delete options[key]}),Object.keys(this.browserHistoryOptions).forEach(function(key){return "undefined"===_this6.browserHistoryOptions[key]&&delete _this6.browserHistoryOptions[key]}),app.moduleCacheSet("browserHistoryEvent",!1),historyParams.cvid&&"undefined"!==historyParams.cvid&&app.moduleCacheSet("CurrentCvId",historyParams.cvid),app.setMainParams("showType",options.time),app.setMainParams("usersId",options.user),app.setMainParams("defaultView",this.browserHistoryOptions);}return window.addEventListener("popstate",function(){app.moduleCacheSet("browserHistoryEvent",!0);},!1),options}/**
	 * Register filters
	 */},{key:"registerFilters",value:function registerFilters(){var _this7=this,sideBar=this.getSidebarView();!sideBar||0>=sideBar.length||(sideBar.find(".js-sidebar-filter-container").each(function(_,row){var formContainer=$(row);_this7.registerUsersChange(formContainer),App.Fields.Picklist.showSelect2ElementView(formContainer.find("select"));var body=formContainer.find(".js-sidebar-filter-body");body.length&&app.showNewScrollbar(body,{suppressScrollX:!0}),_this7.registerFilterForm(formContainer);}),this.registerSelectAll(sideBar),null!==app.moduleCacheGet("CurrentCvId")&&this.container.find(".js-calendar__extended-filter-tab [data-cvid=\""+app.moduleCacheGet("CurrentCvId")+"\"] a").addClass("active"));}/**
	 * Register filter for users and groups
	 * @param {jQuery} container
	 */},{key:"registerFilterForm",value:function registerFilterForm(container){var _this8=this,self=this,search=container.find(".js-filter__search");search.length&&(search.on("keyup",function(e){_this8.findElementOnList($(e.currentTarget));}),container.find(".js-filter__clear").length&&container.find(".js-filter__clear").on("click",function(){search.val(""),_this8.findElementOnList(search);})),container.find(".js-calendar__filter__select, .filterField, .js-filter__container_checkbox_list .js-filter__item__val").each(function(_,e){var element=$(e);if(0==element.length)return !0;var name=element.data("cache"),cachedValue=app.moduleCacheGet(name);if(cachedValue!==void 0)"SELECT"==element.prop("tagName")?element.val(cachedValue):"INPUT"==element.prop("tagName")&&"checkbox"==element.attr("type")&&element.prop("checked",cachedValue);else if(name&&cachedValue===void 0&&!element.find(":selected").length&&0!==element.data("selected")){var allOptions=[];element.find("option").each(function(i,option){allOptions.push($(option).val());}),element.val(allOptions),app.moduleCacheSet(name,cachedValue);}element.off("change"),"SELECT"==element.prop("tagName")&&App.Fields.Picklist.showSelect2ElementView(element),self.registerFilterOptionChangeEvent(element);});}/**
	 * Register events for filter option change
	 * @param {jQuery} element
	 */},{key:"registerFilterOptionChangeEvent",value:function registerFilterOptionChangeEvent(element){var _this9=this;element.on("change",function(e){var item=$(e.currentTarget),value=item.val();null==value&&(value=""),"checkbox"==item.attr("type")&&(value=element.is(":checked")),app.moduleCacheSet(item.data("cache"),value),_this9.reloadCalendarData();});}/**
	 * Find element on list (user, group)
	 * @param {jQuery} target
	 */},{key:"findElementOnList",value:function findElementOnList(target){var value=target.val().toLowerCase(),container=target.closest(".js-filter__container");container.find(".js-filter__item__value").filter(function(){var item=$(this).closest(".js-filter__item__container");-1<$(this).text().trim().toLowerCase().indexOf(value)?item.removeClass("d-none"):item.addClass("d-none");});}/**
	 * Register users change
	 * @param {jQuery} formContainer
	 */},{key:"registerUsersChange",value:function registerUsersChange(formContainer){var _this10=this;formContainer.find(".js-input-user-owner-id-ajax, .js-input-user-owner-id").on("change",function(){_this10.reloadCalendarData();});}/**
	 * Register change on select all checkbox
	 * @param {jQuery} formContainer
	 */},{key:"registerSelectAll",value:function registerSelectAll(formContainer){var _this11=this;formContainer.find(".js-select-all").on("change",function(e){var checkboxSelectAll=$(e.currentTarget),checkboxes=formContainer.find(".js-input-user-owner-id-ajax, .js-input-user-owner-id");checkboxSelectAll.is(":checked")?checkboxes.prop("checked",!0):(checkboxes.prop("checked",!1),formContainer.find("#ownerId"+CONFIG.userId).prop("checked",!0)),_this11.reloadCalendarData();});}/**
	 * Register sidebar events.
	 */},{key:"registerSidebarEvents",value:function registerSidebarEvents(){var _this12=this;$(".bodyContents").on("Vtiger.Widget.Load.undefined",function(){_this12.registerSelect2Event();});}/**
	 * Get sidebar view panel
	 * @returns {jQuery}
	 */},{key:"getSidebarView",value:function getSidebarView(){return this.sidebarView&&this.sidebarView.length||(this.sidebarView=this.container.find(".js-calendar-right-panel")),this.sidebarView}/**
	 * Get current cv id
	 * @returns {int}
	 */},{key:"getCurrentCvId",value:function getCurrentCvId(){var tab=$(".js-calendar__container .js-calendar__extended-filter-tab");return 0===tab.length&&(tab=$(".js-calendar__header-buttons .js-calendar__extended-filter-tab")),tab.find(".active").parent().data("cvid")}/**
	 * Register select2 event.
	 */},{key:"registerSelect2Event",value:function registerSelect2Event(){var self=this;$(".siteBarRight .js-calendar__filter__select").each(function(){var element=$(this),name=element.data("cache"),cachedValue=app.moduleCacheGet(name);if(0<element.length&&cachedValue!==void 0)"SELECT"==element.prop("tagName")&&element.val(cachedValue);else if(0<element.length&&cachedValue===void 0&&!element.find(":selected").length){var allOptions=[];element.find("option").each(function(_i,option){allOptions.push($(option).val());}),element.val(allOptions),app.moduleCacheSet(name,cachedValue);}});var selectsElements=$(".siteBarRight .select2, .siteBarRight .filterField");selectsElements.off("change"),App.Fields.Picklist.showSelect2ElementView(selectsElements),selectsElements.on("change",function(){var element=$(this),value=element.val();null==value&&(value=""),"checkbox"==element.attr("type")&&(value=element.is(":checked")),app.moduleCacheSet(element.data("cache"),value),self.reloadCalendarData();});}/**
	 * Register button select all.
	 */},{key:"registerButtonSelectAll",value:function registerButtonSelectAll(){$(".selectAllBtn").on("click",function(){var selectAllLabel=$(this).find(".selectAll"),deselectAllLabel=$(this).find(".deselectAll");selectAllLabel.hasClass("d-none")?(selectAllLabel.removeClass("d-none"),deselectAllLabel.addClass("d-none"),$(this).closest(".quickWidget").find("select option").prop("selected",!1)):($(this).closest(".quickWidget").find("select option").prop("selected",!0),deselectAllLabel.removeClass("d-none"),selectAllLabel.addClass("d-none")),$(this).closest(".quickWidget").find("select").trigger("change");});}/**
	 * Register add button.
	 */},{key:"registerAddButton",value:function registerAddButton(){var _this13=this;$(".js-add").on("click",function(){_this13.getCalendarCreateView().done(function(data){App.Components.QuickCreate.showModal(data,{callbackFunction:function callbackFunction(){_this13.reloadCalendarData();}});});});}/**
	 * Get calendar create view.
	 * @returns {promise}
	 */},{key:"getCalendarCreateView",value:function getCalendarCreateView(){var self=this,aDeferred=jQuery.Deferred();if(!1!==this.calendarCreateView)return aDeferred.resolve(this.calendarCreateView),aDeferred.promise();var progressInstance=jQuery.progressIndicator();return this.loadCalendarCreateView().done(function(data){progressInstance.hide(),self.calendarCreateView=data,aDeferred.resolve(data);}).fail(function(){progressInstance.hide();}),aDeferred.promise()}/**
	 * Load calendar create view.
	 * @returns {promise}
	 */},{key:"loadCalendarCreateView",value:function loadCalendarCreateView(){var aDeferred=jQuery.Deferred(),moduleName=app.getModuleName();return App.Components.QuickCreate.getForm("index.php?module="+moduleName+"&view=QuickCreateAjax",moduleName).done(function(data){aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()}/**
	 * Function invokes by FullCalendar, sets selected days in form
	 * @param info
	 */},{key:"selectDays",value:function selectDays(info){var _this14=this;this.getCalendarCreateView().done(function(data){App.Components.QuickCreate.showModal(data,{callbackFunction:function callbackFunction(){self.reloadCalendarData();},callbackPostShown:function callbackPostShown(modal){_this14.selectCallbackCreateModal(modal,info);}});});}/**
	 * Callback after shown create modal
	 * @param {jQuery} modal
	 */},{key:"selectCallbackCreateModal",value:function selectCallbackCreateModal(modal,info){var startDate=info.start,endDate=info.end;if(info.allDay&&endDate.setDate(endDate.getDate()-1),info.allDay){var startDateSplitted=this.startHour.split(":"),endDateSplitted=this.endHour.split(":");if(startDate.setHours(startDateSplitted[0],startDateSplitted[1]),endDate.setHours(endDateSplitted[0],endDateSplitted[1]),startDate.toDateString()===endDate.toDateString()){var activityType=modal.find("[name=\"activitytype\"]").val(),activityDurations=JSON.parse(modal.find("[name=\"defaultOtherEventDuration\"]").val()),minutes=60;for(var i in activityDurations)if(activityDurations[i].activitytype===activityType){minutes=parseInt(activityDurations[i].duration);break}minutes&&endDate.setMinutes(endDate.getMinutes()+minutes);}}var dateFormat=CONFIG.dateFormat,timeFormat=CONFIG.hourFormat,dateField=modal.find("[name=\"date_start\"]");dateField.length&&(dateFormat=dateField.data("dateFormat"));var timeField=modal.find("[name=\"time_start\"]");timeField.length&&(timeFormat=timeField.data("format"));var defaultTimeFormat="";defaultTimeFormat=24==timeFormat?"HH:mm":"hh:mm A",modal.find("[name=\"date_start\"]").val(App.Fields.Date.dateToUserFormat(startDate,dateFormat)),modal.find("[name=\"due_date\"]").val(App.Fields.Date.dateToUserFormat(endDate,dateFormat)),!0===modal.find(".js-autofill").prop("checked")?Calendar_Edit_Js.getInstance().getFreeTime(modal):(modal.find("[name=\"time_start\"]").val(moment(startDate).format(defaultTimeFormat)),modal.find("[name=\"time_end\"]").val(moment(endDate).format(defaultTimeFormat)));}/**
	 * Register extra sources events.
	 */},{key:"registerExtraSources",value:function registerExtraSources(){var sideBar=this.getSidebarView();if(sideBar&&!(0>=sideBar.length)){var self=this;sideBar.on("click",".js-source-modal",function(){var _this15=this;self.getExtraSourcesView({id:this.dataset.id}).done(function(html){if(html){var row=null;_this15.dataset.id&&(row=$(_this15).closest(".js-filter__item__container")),app.showModalWindow(html,function(modal){self.registerExtraSourcesModal(modal,row);});}});}),sideBar.on("click",".js-source-delete",function(){var _this16=this;app.showConfirmModal({text:app.vtranslate("JS_LBL_ARE_YOU_SURE_YOU_WANT_TO_DELETE"),confirmedCallback:function confirmedCallback(){AppConnector.request({module:self.module?self.module:CONFIG.module,action:"Calendar",mode:"deleteExtraSources",id:_this16.dataset.id}).done(function(){$(_this16).closest(".js-filter__item__container").remove(),self.reloadCalendarData();});}});});}}/**
	 * Get extra sources view HTML.
	 * @param {object} params
	 * @returns {promise}
	 */},{key:"getExtraSourcesView",value:function getExtraSourcesView(params){delete params.action;var aDeferred=jQuery.Deferred();return AppConnector.request($.extend({module:this.module?this.module:CONFIG.module,view:"CalendarExtraSourcesModal"},params)).done(function(response){aDeferred.resolve(response);}).fail(function(error,err){app.errorLog(error,err),aDeferred.reject(error);}),aDeferred.promise()}/**
	 * Register extra sources modal events.
	 * @param {jQuery} modal
	 */},{key:"registerExtraSourcesModal",value:function registerExtraSourcesModal(modal,row){var _this17=this,self=this,picker=modal.find(".js-color-picker"),form=modal.find(".js-modal-form"),nav=this.getSidebarView().find(".js-extra-sources-nav"),navTemplate=this.getSidebarView().find(".js-nav-template");picker.on("click",function(){App.Fields.Colors.showPicker({color:picker.val(),bgToUpdate:modal.find(".js-color-picker__color"),fieldToUpdate:picker});}),modal.find("[name=\"target_module\"],[name=\"type\"]").on("change",function(){_this17.getExtraSourcesView(form.serializeFormData()).done(function(html){if(html){var dynamicFields=modal.find(".js-dynamic-fields");dynamicFields.html(html),App.Fields.Picklist.changeSelectElementView(dynamicFields);}});}),modal.find(".js-modal__save").on("click",function(){if(!0===form.validationEngine("validate")){var formData=form.serializeFormData();AppConnector.request(formData).done(function(response){app.hideModalWindow(),row?(row.find(".js-background").css("background",formData.color),row.find(".js-label").text(formData.label)):(nav.append(navTemplate.html().replace(/_SOURCE_ID_/g,response.result).replace(/_COLOR_/g,formData.color).replace(/_LABEL_/g,formData.label)),self.registerFilterOptionChangeEvent(nav.last().find("input"))),self.reloadCalendarData();}).fail(function(error,err){app.errorLog(error,err);});}}),modal.find("[name=\"target_module\"]").trigger("change");}/**
	 * Register events.
	 */},{key:"registerEvents",value:function registerEvents(){this.registerFilters(),this.registerSidebarEvents(),this.renderCalendar(),this.registerButtonSelectAll(),this.registerAddButton(),this.registerExtraSources();}}])}(),_defineProperty(_Class,"monthFormat",{"yyyy-mm-dd":"YYYY-MMMM","mm-dd-yyyy":"MMMM-YYYY","dd-mm-yyyy":"MMMM-YYYY","yyyy.mm.dd":"YYYY.MMMM","mm.dd.yyyy":"MMMM.YYYY","dd.mm.yyyy":"MMMM.YYYY","yyyy/mm/dd":"YYYY/MMMM","mm/dd/yyyy":"MMMM/YYYY","dd/mm/yyyy":"MMMM/YYYY"}),_defineProperty(_Class,"viewsNamesMap",{month:"dayGridMonth",basicWeek:"dayGridWeek",basicDay:"dayGridDay",timeGridWeek:"timeGridWeek",timeGridDay:"timeGridDay"}),_defineProperty(_Class,"viewsNamesLabels",{dayGridMonth:"month",dayGridWeek:"week",dayGridDay:"day",listWeek:"week",timeGridWeek:"week",timeGridDay:"day"}),_Class);
//# sourceMappingURL=Calendar.min.js.map
