const rollup = require('rollup'),
	{ babel } = require('@rollup/plugin-babel'),
	finder = require('findit')('../'),
	path = require('path'),
	sourcemaps = require('rollup-plugin-sourcemaps'),
	{ done } = require('@vue/cli-shared-utils'),
	{ terser } = require('rollup-plugin-terser');

const dirModules = __dirname + '/node_modules/'
let filesToMin = []
const args = process.argv.slice(2);
const filterPath = args.length ? path.resolve('../../' + args[0]) : null;

async function build(fileName) {
	const inputOptions = {
			input: fileName,
			treeshake: false,
			plugins: [
				babel({
					babelrc: false,
					babelHelpers: 'inline',
					presets: [
						[
							`${dirModules}@babel/preset-env`,
							{
								modules: false
							}
						],
						[
							`${dirModules}babel-preset-minify`,
							{
								typeConstructors: false,
								mangle: false,
								builtIns: false
							}
						]
					],
					plugins: [
						`${dirModules}@babel/plugin-proposal-class-properties/lib/index.js`,
						`${dirModules}@babel/plugin-proposal-private-methods/lib/index.js`,
						`${dirModules}@babel/plugin-proposal-private-property-in-object/lib/index.js`,
						`${dirModules}@babel/plugin-proposal-object-rest-spread/lib/index.js`,
						`${dirModules}@babel/plugin-transform-classes/lib/index.js`
					]
				}),
				sourcemaps(),
				terser({
					mangle: false,
					format: {
						comments: /^!|license|@preserve|@cc_on/i
					},
					compress: {
						defaults: false
					}
				})
			]
		},
		outputOptions = {
			sourcemap: true,
			file: fileName.replace('.js', '.min.js'),
			format: 'cjs'
		}
	// create a bundle
	const bundle = await rollup.rollup(inputOptions)
	// generate code and a sourcemap
	await bundle.generate(outputOptions)
	// or write the bundle to disk
	await bundle.write(outputOptions)
}

finder.on('directory', (dir, stat, stop) => {
	const base = path.basename(dir)
	if (base === 'node_modules' || base === 'libraries' || base === 'vendor' || base === '_private' || base === 'src') stop()
})

finder.on('file', (file) => {
	const re = new RegExp('(?<!\\.min)\\.js$')
	if (file.includes('roundcube') && !(!file.includes('skins') && file.includes('yetiforce'))) return
	if (file.endsWith('vue.js')) return
	if (file.match(re)) {
		if (filterPath) {
			if (path.resolve(file).startsWith(filterPath)) {
				filesToMin.push(file);
			}
		} else {
			filesToMin.push(file);
		}
	}
})

finder.on('end', async () => {
	for (const file of filesToMin) {
		console.log('Building... ' + file)
		try {
			await build(file)
			done(file)
		} catch (err) {
			console.log(err)
		}
	}
})
