<?php

declare(strict_types=1);

namespace N1ebieski\KSEFClient\Factories;

use Monolog\Formatter\LineFormatter;
use Monolog\Handler\StreamHandler;
use Monolog\Level;
use Monolog\Logger;
use N1ebieski\KSEFClient\Overrides\PsrDiscovery\Discovery\Discover;
use N1ebieski\KSEFClient\ValueObjects\LogPath;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;
use PsrDiscovery\Discover as BaseDiscover;
use PsrDiscovery\Entities\CandidateEntity;

final class LoggerFactory extends AbstractFactory
{
    /**
     * @param null|LogLevel::* $level
     */
    public static function make(?LogPath $logPath = null, string | null $level = null): ?LoggerInterface
    {
        $logger = BaseDiscover::log();

        if ($logger !== null) {
            return $logger;
        }

        if ( ! $logPath instanceof LogPath) {
            return null;
        }

        $candidates = array_map(fn (CandidateEntity $candidate): string => $candidate->getPackage(), Discover::logs());

        if (in_array('monolog/monolog', $candidates)) {
            $handler = new StreamHandler(
                $logPath->value,
                $level !== null ? Level::fromName($level) : Level::Debug
            );
            $formatter = new LineFormatter(
                allowInlineLineBreaks: true,
                includeStacktraces: true
            );
            $handler->setFormatter($formatter);

            return new Logger('ksef-php-client', [$handler]);
        }

        return null;
    }
}
