<?php

declare(strict_types=1);

namespace N1ebieski\KSEFClient\Resources\Testdata\RateLimits;

use N1ebieski\KSEFClient\Contracts\Exception\ExceptionHandlerInterface;
use N1ebieski\KSEFClient\Contracts\HttpClient\HttpClientInterface;
use N1ebieski\KSEFClient\Contracts\HttpClient\ResponseInterface;
use N1ebieski\KSEFClient\Contracts\Resources\Testdata\RateLimits\RateLimitsResourceInterface;
use N1ebieski\KSEFClient\Requests\Testdata\RateLimits\Limits\LimitsHandler;
use N1ebieski\KSEFClient\Requests\Testdata\RateLimits\Limits\LimitsRequest;
use N1ebieski\KSEFClient\Requests\Testdata\RateLimits\Production\ProductionHandler;
use N1ebieski\KSEFClient\Requests\Testdata\RateLimits\Reset\ResetHandler;
use N1ebieski\KSEFClient\Resources\AbstractResource;
use Throwable;

final class RateLimitsResource extends AbstractResource implements RateLimitsResourceInterface
{
    public function __construct(
        private readonly HttpClientInterface $client,
        private readonly ExceptionHandlerInterface $exceptionHandler
    ) {
    }

    public function limits(LimitsRequest | array $request): ResponseInterface
    {
        try {
            if ($request instanceof LimitsRequest === false) {
                $request = LimitsRequest::from($request);
            }

            return (new LimitsHandler($this->client))->handle($request);
        } catch (Throwable $throwable) {
            throw $this->exceptionHandler->handle($throwable);
        }
    }

    public function reset(): ResponseInterface
    {
        try {
            return (new ResetHandler($this->client))->handle();
        } catch (Throwable $throwable) {
            throw $this->exceptionHandler->handle($throwable);
        }
    }

    public function production(): ResponseInterface
    {
        try {
            return (new ProductionHandler($this->client))->handle();
        } catch (Throwable $throwable) {
            throw $this->exceptionHandler->handle($throwable);
        }
    }
}
