<?php

declare(strict_types=1);

namespace N1ebieski\KSEFClient\ValueObjects\Requests\Sessions;

use N1ebieski\KSEFClient\Contracts\ValueAwareInterface;
use N1ebieski\KSEFClient\Support\AbstractValueObject;
use Stringable;

final class Ilosc extends AbstractValueObject implements ValueAwareInterface, Stringable
{
    public function __construct(public readonly int $value)
    {
    }

    public function __toString(): string
    {
        return (string) $this->value;
    }

    public static function from(int $value): self
    {
        return new self($value);
    }
}
